/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr.indexer;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.DateUtil;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.helper.impl.JenaResourceHelper;
import org.ow2.weblab.core.model.Audio;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.Image;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Text;
import org.ow2.weblab.core.model.Video;
import org.ow2.weblab.core.services.Indexer;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.indexer.IndexArgs;
import org.ow2.weblab.core.services.indexer.IndexReturn;
import org.ow2.weblab.services.solr.SolrComponent;
import org.ow2.weblab.services.solr.indexer.SolrIndexer;
import org.ow2.weblab.services.solr.indexer.SolrIndexerConfig;
import org.ow2.weblab.util.index.Field;

@WebService(endpointInterface="org.ow2.weblab.core.services.Indexer")
public class SolrIndexer
implements Indexer {
    public static final String BEAN_NAME = "indexerServiceBean";
    private Log logger = LogFactory.getLog(SolrIndexer.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private SolrIndexerConfig indexerConfig;
    private String solrURL;
    private boolean noCore = false;

    @PostConstruct
    public void init() {
        try {
            SolrComponent.getInstance((String)this.solrURL, null);
            if (this.indexerConfig == null) {
                // empty if block
            }
            new URL(this.solrURL);
        }
        catch (WebLabCheckedException e) {
            throw new WebLabUncheckedException("Cannot start the SolrComponent.", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new WebLabUncheckedException("Cannot start the service. The solrULR is invalid [" + this.solrURL + "].", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
    }

    public IndexReturn index(IndexArgs args) throws UnexpectedException, InvalidParameterException, ServiceNotConfiguredException {
        MediaUnit unit = this.checkArgs(args);
        if (unit instanceof Audio || unit instanceof Video || unit instanceof Image) {
            this.logger.warn((Object)("MediaUnit of type: " + unit.getClass().getSimpleName() + " cannot be indexed with Solr."));
            return new IndexReturn();
        }
        try {
            SolrInputDocument doc = this.convertMediaUnit(unit);
            SolrComponent instance = this.noCore ? SolrComponent.getInstance((String)this.solrURL, null) : SolrComponent.getInstance((String)this.solrURL, (String)args.getUsageContext());
            instance.addDocument(doc);
        }
        catch (WebLabCheckedException e) {
            throw new UnexpectedException("Cannot index document.", (Throwable)e);
        }
        return new IndexReturn();
    }

    private MediaUnit checkArgs(IndexArgs args) throws InvalidParameterException {
        if (args == null) {
            this.logger.error((Object)"IndexArgs was null.");
            throw new InvalidParameterException("IndexArgs was null.", "IndexArgs was null.");
        }
        if (args.getResource() == null) {
            this.logger.error((Object)"Args must contain a non-null Resource to index");
            throw new InvalidParameterException("Args must contain a non-null Resource to index", "Args must contain a non-null Resource to index");
        }
        if (!(args.getResource() instanceof MediaUnit)) {
            this.logger.error((Object)"Resource to index is not a MediaUnit.");
            throw new InvalidParameterException("Resource to index is not a MediaUnit.", "Resource to index is not a MediaUnit.");
        }
        return (MediaUnit)args.getResource();
    }

    private SolrInputDocument convertMediaUnit(MediaUnit unit) throws WebLabCheckedException {
        SolrInputDocument doc = new SolrInputDocument();
        try {
            new URI(unit.getUri());
        }
        catch (URISyntaxException e) {
            throw new WebLabCheckedException("Resource to index does not have valid URI.", (Throwable)e);
        }
        doc.addField("id", (Object)unit.getUri());
        for (Field field : this.indexerConfig.getFields()) {
            if (field.isIndexTextContent()) {
                this.addTextToField(doc, field.getName(), unit);
            }
            if (field.getProperties() == null || field.getProperties().size() <= 0) continue;
            JenaResourceHelper hlpr = new JenaResourceHelper((Resource)unit);
            HashSet subjects = new HashSet();
            for (String prop : field.getProperties()) {
                subjects.addAll(hlpr.getSubjsOnPred(prop));
            }
            if (field.getEntityTypes() != null && field.getEntityTypes().size() > 0) {
                HashSet validEntityURIs = new HashSet();
                for (String entityTypeURI : field.getEntityTypes()) {
                    validEntityURIs.addAll(hlpr.getSubjsOnPredRes("http://www.w3.org/1999/02/22-rdf-syntax-ns#type", entityTypeURI));
                }
                subjects.retainAll(validEntityURIs);
            }
            for (String subject : subjects) {
                for (String property : field.getProperties()) {
                    List values = hlpr.getLitsOnPredSubj(subject, property);
                    for (String value : values) {
                        this.addFieldValue(doc, field, value);
                    }
                }
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFieldValue(SolrInputDocument doc, Field field, String value) throws WebLabCheckedException {
        switch (1.$SwitchMap$org$ow2$weblab$util$index$Field$FieldType[field.getType().ordinal()]) {
            case 1: {
                Date d;
                SimpleDateFormat simpleDateFormat = this.dateFormat;
                synchronized (simpleDateFormat) {
                    try {
                        d = DateUtil.parseDate((String)value);
                    }
                    catch (ParseException e) {
                        throw new WebLabCheckedException("Cannot convert field value [" + value + "] to date.", (Throwable)e);
                    }
                }
                doc.addField(field.getName(), (Object)d);
                break;
            }
            case 2: {
                long l;
                try {
                    l = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new WebLabCheckedException("Cannot convert field value [" + value + "] to long.", (Throwable)e);
                }
                doc.addField(field.getName(), (Object)l);
                break;
            }
            default: {
                doc.addField(field.getName(), (Object)value);
            }
        }
    }

    private void addTextToField(SolrInputDocument doc, String name, MediaUnit unit) {
        if (unit instanceof Document) {
            Document document = (Document)unit;
            for (MediaUnit u : document.getMediaUnit()) {
                this.addTextToField(doc, name, u);
            }
        } else if (unit instanceof Text) {
            Text text = (Text)unit;
            doc.addField(name, (Object)text.getContent());
        } else {
            this.logger.debug((Object)("Canot extarct text content from [" + unit.getClass().getSimpleName() + "]."));
        }
    }

    public SolrIndexerConfig getIndexerConfig() {
        return this.indexerConfig;
    }

    public void setIndexerConfig(SolrIndexerConfig indexerConfig) {
        this.indexerConfig = indexerConfig;
    }

    public String getSolrURL() {
        return this.solrURL;
    }

    public void setSolrURL(String solrURL) {
        this.solrURL = solrURL;
    }

    public boolean isNoCore() {
        return this.noCore;
    }

    public void setNoCore(boolean noCore) {
        this.noCore = noCore;
    }
}

