package org.ow2.weblab.util;

import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.Query;

public abstract class WebLabQueryParser {

	/**
	 * Build a string request based on the content of a Query.
	 * @param q a Query
	 * @param hlpr a JenaResourceHelper initialized on the Query
	 * @return the request as a string
	 * @throws WebLabCheckedException
	 */
	public abstract String getRequest(Query q, ResourceHelper hlpr) throws WebLabCheckedException;
	
	/**
	 * Build a string query based on the content of a ComposedQuery.
	 * 
	 * This method is for now limited to simple composition (ie one level
	 * ComposedQuery) and only accepting StringQuery as sub- queries.
	 * 
	 * @param q
	 *            the ComposedQuery
	 * @param hlpr
	 *            a JenaResourceHelper initialized on the ComposedQuery
	 * @return the composed request as a string
	 * @throws WebLabCheckedException
	 */
	public abstract String getComposedRequest(ComposedQuery q, ResourceHelper hlpr) throws WebLabCheckedException;

	/**
	 * Extract the request from the StringQuery possibly using the property
	 * HAS_SCOPE to restrict request scope and adapt syntax.
	 * 
	 * @param q
	 *            a StrinQuery
	 * @return the request as a String
	 */
	public abstract String getRequestWithScope(Query q, ResourceHelper hlpr) throws WebLabCheckedException;

	/**
	 * Test if the property TO_BE_ORDERED_BY exists on the query and get its
	 * value if applicable.
	 * 
	 * @param q
	 *            a StrinQuery
	 * @return The URI of the property to be used for ordering or null if empty.
	 */
	public abstract String getOrderBy(Query q, ResourceHelper hlpr) throws WebLabCheckedException;

	/**
	 * Test if the property ASCENDENT_ORDERING_MODE_EXPECTED is set to true.
	 * 
	 * @param q
	 *            a StrinQuery
	 * @return true of false, the value of the property (default is false)
	 */
	public abstract boolean getOrder(Query q, ResourceHelper hlpr) throws WebLabCheckedException;
}
