/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr.analyser;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.retrieval.WRetrievalAnnotator;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.rdf.Value;
import org.ow2.weblab.services.solr.SolrComponent;
import org.ow2.weblab.services.solr.SolrConfig;
import org.ow2.weblab.services.solr.analyser.ResultSetMetadataEnrichment;
import org.ow2.weblab.util.index.Field;

@WebService(endpointInterface="org.ow2.weblab.core.services.Analyser")
public class ResultSetMetadataEnrichment
implements Analyser {
    public static final String BEAN_NAME = "resultSetMetaEnricherServiceBean";
    private Log logger;
    private SolrConfig conf;
    private List<Field> fields;
    private SimpleDateFormat dateFormat;

    @PostConstruct
    public void init() {
        this.logger = LogFactory.getLog(ResultSetMetadataEnrichment.class);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            new URL(this.conf.getSolrURL());
        }
        catch (MalformedURLException e) {
            throw new WebLabUncheckedException("Cannot start the service. The solrULR is invalid [" + this.conf.getSolrURL() + "].", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
    }

    public ProcessReturn process(ProcessArgs args) throws AccessDeniedException, UnexpectedException, InvalidParameterException, ContentNotAvailableException, InsufficientResourcesException, UnsupportedRequestException, ServiceNotConfiguredException {
        this.checkArgs(args);
        ResultSet enrichSet = this.addMetadataToResultSet(args.getUsageContext(), (ResultSet)args.getResource());
        ProcessReturn ret = new ProcessReturn();
        ret.setResource((Resource)enrichSet);
        return ret;
    }

    private void checkArgs(ProcessArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("Input args for [" + this.getClass().getSimpleName() + "] cannot be null.");
        }
    }

    public ResultSet addMetadataToResultSet(String usageContext, ResultSet resultSet) throws UnexpectedException {
        try {
            WRetrievalAnnotator wra = new WRetrievalAnnotator(new URI(resultSet.getUri()), resultSet.getPok());
            JenaPoKHelper hlpr = new JenaPoKHelper(resultSet.getPok());
            hlpr.setAutoCommitMode(false);
            ArrayList docUris = new ArrayList();
            if (wra.readHit() == null || wra.readHit().size() == 0) {
                this.logger.debug((Object)"No hit in the resultSet.");
            } else {
                Value hits = wra.readHit();
                for (URI hit : hits) {
                    wra.startInnerAnnotatorOn(hit);
                    docUris.addAll(wra.readLinkedTo().getValues());
                    wra.endInnerAnnotator();
                }
                String[] uris = new String[docUris.size()];
                for (int k = 0; k < docUris.size(); ++k) {
                    uris[k] = ((URI)docUris.get(k)).toString();
                }
                SolrComponent instance = this.conf.isNoCore() ? SolrComponent.getInstance((SolrConfig)this.conf, null) : SolrComponent.getInstance((SolrConfig)this.conf, (String)usageContext);
                QueryResponse response = instance.getMetaData(uris);
                if (response.getResults() == null || response.getResults().size() == 0) {
                    throw new WebLabCheckedException("Cannot get metadata from Solr.");
                }
                if (response.getResults().size() < docUris.size()) {
                    this.logger.info((Object)("Solr returned only " + response.getResults().size() + "... We'll do what we can."));
                }
                for (SolrDocument doc : response.getResults()) {
                    for (Field field : this.fields) {
                        this.addFieldDataToPok(hlpr, (String)doc.getFieldValue("id"), doc, field);
                    }
                }
                hlpr.commit();
            }
            this.logger.info((Object)("Metadata enrichment done for [" + resultSet.getUri() + "]."));
        }
        catch (URISyntaxException e) {
            throw new WebLabUncheckedException("Some URI were invalid during annotation. This should not happend really...", (Throwable)e);
        }
        catch (WebLabCheckedException e) {
            throw new UnexpectedException("Well metadata enrichment failed: " + e.getMessage(), (Throwable)e);
        }
        return resultSet;
    }

    private void addFieldDataToPok(JenaPoKHelper hlpr, String docURI, SolrDocument doc, Field field) throws WebLabCheckedException {
        if (field.getProperties().size() == 1) {
            if (doc.getFieldValue(field.getName()) == null) {
                this.logger.debug((Object)("Cannot get metadata from field [" + field.getName() + "]. It does not contain anything."));
            } else {
                block4: for (Object value : doc.getFieldValues(field.getName())) {
                    switch (1.$SwitchMap$org$ow2$weblab$util$index$Field$FieldType[field.getType().ordinal()]) {
                        case 1: {
                            Date d = (Date)value;
                            hlpr.createLitStat(docURI, ((String)field.getProperties().get(0)).trim(), this.dateFormat.format(d));
                            continue block4;
                        }
                        case 2: {
                            hlpr.createResStat(docURI, ((String)field.getProperties().get(0)).trim(), value.toString());
                            continue block4;
                        }
                    }
                    hlpr.createLitStat(docURI, ((String)field.getProperties().get(0)).trim(), value.toString());
                }
            }
        } else {
            throw new WebLabCheckedException("Cannot get metadata from field [" + field.getName() + "]. It should not be in the metadata enrichmenet field list.");
        }
    }

    public SolrConfig getConf() {
        return this.conf;
    }

    public void setConf(SolrConfig conf) {
        this.conf = conf;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }
}

