/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr.analyser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.model.ComposedResource;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.services.solr.SolrComponent;
import org.ow2.weblab.services.solr.SolrConfig;

@WebService(endpointInterface="org.ow2.weblab.core.services.Analyser")
public class SpellSuggestion
implements Analyser {
    public static final String BEAN_NAME = "spellSuggestionServiceBean";
    private static final String IDRES_SPELL_PREFIX = "spell";
    private static long suggestionCounter = 0L;
    private static long queryCounter = 0L;
    private Log logger;
    private SolrConfig conf;
    private int nbSuggestion = 10;

    @PostConstruct
    public void init() {
        this.logger = LogFactory.getLog(SpellSuggestion.class);
        try {
            new URL(this.conf.getSolrURL());
        }
        catch (MalformedURLException e) {
            throw new WebLabUncheckedException("Cannot start the service. The solrULR is invalid [" + this.conf.getSolrURL() + "].", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        this.logger.info((Object)"Destroying SolR SpellSuggestion service.");
    }

    public ProcessReturn process(ProcessArgs args) throws AccessDeniedException, UnexpectedException, InvalidParameterException, ContentNotAvailableException, InsufficientResourcesException, UnsupportedRequestException, ServiceNotConfiguredException {
        this.checkArgs(args);
        ResultSet enrichSet = this.doSpellSuggest(args.getUsageContext(), (ResultSet)args.getResource());
        ProcessReturn ret = new ProcessReturn();
        ret.setResource((Resource)enrichSet);
        return ret;
    }

    public ResultSet doSpellSuggest(String usageContext, ResultSet set) {
        try {
            if (!(set.getResource().get(0) instanceof StringQuery)) {
                throw new WebLabCheckedException("There is no query in the ResultSet.");
            }
            StringQuery q = (StringQuery)set.getResource().get(0);
            String originalQuery = q.getRequest();
            SolrComponent instance = this.conf.isNoCore() ? SolrComponent.getInstance((SolrConfig)this.conf, null) : SolrComponent.getInstance((SolrConfig)this.conf, (String)usageContext);
            QueryResponse response = instance.spellSuggest(q.getRequest());
            SpellCheckResponse scr = response.getSpellCheckResponse();
            if (scr == null || scr.isCorrectlySpelled()) {
                this.logger.debug((Object)"The query in the ResultSetis correctly spelled.");
            } else {
                this.logger.debug((Object)"Getting spell check suggestions");
                HashSet<Object> suggestedQueries = new HashSet<Object>();
                Map mscr = scr.getSuggestionMap();
                if (mscr.size() == 0) {
                    this.logger.debug((Object)"The query isn't correctly spelled, but we don't have any suggestion.");
                } else if (mscr.size() == 1) {
                    String s = (String)mscr.entrySet().iterator().next().getKey();
                    SpellCheckResponse.Suggestion suggestion = (SpellCheckResponse.Suggestion)mscr.get(s);
                    List ls = suggestion.getAlternatives();
                    List fs = suggestion.getAlternativeFrequencies();
                    for (int i = 0; i < ls.size(); ++i) {
                        StringQuery str = (StringQuery)ResourceFactory.createResource((String)"indexsearch.solr", (String)("spellquery" + queryCounter++), StringQuery.class);
                        str.setRequest(originalQuery.replace(originalQuery.substring(suggestion.getStartOffset(), suggestion.getEndOffset()), (CharSequence)ls.get(i)));
                        str.setWeight((float)((Integer)fs.get(i)).intValue());
                        this.logger.debug((Object)("Adding spell check suggestion [" + str.getRequest() + "]@" + str.getWeight()));
                        suggestedQueries.add(str);
                    }
                } else {
                    StringQuery[] topNSuggestedQueries = new StringQuery[this.nbSuggestion];
                    double[] topN = new double[this.nbSuggestion];
                    for (String s : mscr.keySet()) {
                        SpellCheckResponse.Suggestion suggestion = (SpellCheckResponse.Suggestion)mscr.get(s);
                        List ls = suggestion.getAlternatives();
                        List fs = suggestion.getAlternativeFrequencies();
                        HashSet<StringQuery> suggestedQueriesToBeAdded = new HashSet<StringQuery>();
                        for (int i = 0; i < ls.size(); ++i) {
                            if (suggestedQueries.size() > 0) {
                                for (StringQuery stringQuery : suggestedQueries) {
                                    StringQuery str = (StringQuery)ResourceFactory.createResource((String)"indexsearch.solr", (String)("spellquery" + queryCounter++), StringQuery.class);
                                    str.setRequest(stringQuery.getRequest().replace(suggestion.getToken(), (CharSequence)ls.get(i)));
                                    str.setWeight(((float)((Integer)fs.get(i)).intValue() + stringQuery.getWeight()) / 2.0f);
                                    suggestedQueriesToBeAdded.add(str);
                                    this.addTopSocredSuggestion(topN, topNSuggestedQueries, str);
                                }
                            }
                            StringQuery str = (StringQuery)ResourceFactory.createResource((String)"indexsearch.solr", (String)("spellquery" + queryCounter++), StringQuery.class);
                            str.setRequest(originalQuery.replace(suggestion.getToken(), (CharSequence)ls.get(i)));
                            str.setWeight((float)((Integer)fs.get(i)).intValue());
                            suggestedQueries.add(str);
                            this.logger.debug((Object)("Adding spell check suggestion [" + str.getRequest() + "]@" + str.getWeight()));
                            this.addTopSocredSuggestion(topN, topNSuggestedQueries, str);
                        }
                        if (suggestedQueriesToBeAdded.size() <= 0) continue;
                        suggestedQueries.addAll(suggestedQueriesToBeAdded);
                    }
                }
                if (suggestedQueries == null || suggestedQueries.size() == 0) {
                    this.logger.debug((Object)"There is no spell check suggestions done despite the suggested terms...");
                } else {
                    this.logger.debug((Object)"Adding spell check suggestions to result set.");
                    ComposedResource collec = (ComposedResource)ResourceFactory.createResource((String)"indexsearch.solr", (String)(IDRES_SPELL_PREFIX + suggestionCounter++), ComposedResource.class);
                    collec.getResource().addAll(suggestedQueries);
                    set.getResource().add(collec);
                }
            }
            this.logger.info((Object)("Spell suggestion done for [" + set.getUri() + "]."));
        }
        catch (WebLabCheckedException e) {
            this.logger.warn((Object)("Cannot make spell suggestion : " + e.getMessage()));
        }
        return set;
    }

    private void addTopSocredSuggestion(double[] topN, StringQuery[] topNSuggestedQueries, StringQuery str) {
        for (int i = 0; i < topN.length; ++i) {
            if (!(topN[i] < (double)str.getWeight())) continue;
            topN[i] = str.getWeight();
            topNSuggestedQueries[i] = str;
        }
    }

    private void checkArgs(ProcessArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("Input args for [" + this.getClass().getSimpleName() + "] cannot be null.");
        }
    }

    public int getNbSuggestion() {
        return this.nbSuggestion;
    }

    public void setNbSuggestion(int nbSuggestion) {
        this.nbSuggestion = nbSuggestion;
    }

    public SolrConfig getConf() {
        return this.conf;
    }

    public void setConf(SolrConfig conf) {
        this.conf = conf;
    }
}

