/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2011 Cassidian, an EADS company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.services.solr;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.util.index.Field;

public class SolrConfig {
	private static final Log LOGGER = LogFactory.getLog(SolrConfig.class);
	public static final String BEAN_NAME = "configBean";
	public static final String SOLR_HOME_SYSTEM_PROPERTY = "solr.solr.home";

	public static final String FIELD_ID = "id";
	public static final String FIELD_PLAIN_TEXT = "plain_text";
	public static final String SOLR_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
	public static final String FIELD_SEPARATOR = ":";

	private String solrURL;
	private String solrHome;
	private String solrData;
	private boolean noCore = false;

	/**
	 * Util map to get field name based on property URI indexed. Watch out: the
	 * map is loaded only through setFields() method (ie on loading from conf
	 * file) but is not synchronized later on if the field list is changed.
	 */
	private Map<String, Field> propertyToFieldMap = new HashMap<String, Field>();

	/**
	 * Fields used by the index
	 */
	private List<Field> fields;

	public List<Field> getFields() {
		return fields;
	}

	public void setFields(List<Field> fields) {
		this.fields = fields;

		if (fields != null) {
			for (Field f : fields) {
				// mapping entity type in priority
				if (f.getEntityTypes() != null) {
					for (String entityType : f.getEntityTypes()) {
						propertyToFieldMap.put(entityType, f);
					}
				} else {
					// if there isn't any entity type then map on property
					if (f.getProperties() != null) {
						for (String property : f.getProperties()) {
							propertyToFieldMap.put(property, f);
						}
					}
				}

			}
		}
	}

	public Map<String, Field> getPropertyToFieldMap() {
		return propertyToFieldMap;
	}

	public void setPropertyToFieldMap(Map<String, Field> propertyToFieldMap) {
		this.propertyToFieldMap = propertyToFieldMap;
	}

	public String getSolrURL() {
		return solrURL;
	}

	public void setSolrURL(String solrURL) {
		this.solrURL = solrURL;
	}

	public String getSolrHome() {
		return solrHome;
	}

	public void setSolrHome(String solrHome) {
		File f = new File(solrHome);
		if (!f.isAbsolute()) {
			LOGGER.warn("Path to solrHome is not absolute [" + solrHome + "]. This may not work if solrHome is not properly fixed on server side.");
		} else {
			LOGGER.debug("Setting solrHome to a nice absolute path [" + solrHome + "].");
		}
		this.solrHome = solrHome;
	}

	public String getSolrData() {
		return solrData;
	}

	public void setSolrData(String solrData) {
		File f = new File(solrData);
		if (!f.isAbsolute()) {
			LOGGER.warn("Path to solrData is not absolute [" + solrData + "]. This may not work if solrHome is not properly fixed on server side.");
		} else {
			LOGGER.debug("Setting solrData to a nice absolute path [" + solrData + "].");
		}
		this.solrData = solrData;
	}

	public boolean isNoCore() {
		return noCore;
	}

	public void setNoCore(boolean noCore) {
		this.noCore = noCore;
	}
}
