package org.ow2.weblab.util;

import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.StringQuery;

/**
 * Only tackle StringQuery and ComposedQuery. Does not take any annotation into account
 * @author gdupont - WebLab team ; CASSIDIAN, an EADS company
 * @date 2011
 * WebLab model 1.2
 */
public class SimpleQueryParser extends WebLabQueryParser {

	@Override
	public String getRequest(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
		if (q instanceof StringQuery) {
			StringQuery squery = (StringQuery) q;
			return squery.getRequest();
		} else if (q instanceof ComposedQuery) {
			ComposedQuery cquery = (ComposedQuery) q;
			return getComposedRequest(cquery, hlpr);
		}
		return null;
	}

	@Override
	public String getComposedRequest(ComposedQuery q, ResourceHelper hlpr) throws WebLabCheckedException {
		StringBuffer queryString = new StringBuffer();
		queryString.append('(');
		for (Query subQ : q.getQuery()) {
			if (queryString.length() > 1) {
				queryString.append(' ');
			}

			String rq = getRequest(subQ, hlpr);

			if (rq != null) {
				queryString.append(rq);
			}

		}
		queryString.append(')');
		return queryString.toString();
	}

	@Override
	public String getRequestWithScope(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
		throw new WebLabCheckedException("Not implemented.");
	}

	@Override
	public String getOrderBy(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
		throw new WebLabCheckedException("Not implemented.");
	}

	@Override
	public boolean getOrder(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
		throw new WebLabCheckedException("Not implemented.");
	}

}
