/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.util.index.Field;

public class SolrConfig {
    private static final Log LOGGER = LogFactory.getLog(SolrConfig.class);
    public static final String BEAN_NAME = "configBean";
    public static final String SOLR_HOME_SYSTEM_PROPERTY = "solr.solr.home";
    public static final String FIELD_ID = "id";
    public static final String FIELD_PLAIN_TEXT = "plain_text";
    public static final String SOLR_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String FIELD_SEPARATOR = ":";
    private String solrURL;
    private String solrHome;
    private String solrData;
    private boolean noCore = false;
    private Map<String, Field> propertyToFieldMap = new HashMap();
    private List<Field> fields;

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
        if (fields != null) {
            for (Field f : fields) {
                if (f.getEntityTypes() != null) {
                    for (String entityType : f.getEntityTypes()) {
                        this.propertyToFieldMap.put(entityType, f);
                    }
                    continue;
                }
                if (f.getProperties() == null) continue;
                for (String property : f.getProperties()) {
                    this.propertyToFieldMap.put(property, f);
                }
            }
        }
    }

    public Map<String, Field> getPropertyToFieldMap() {
        return this.propertyToFieldMap;
    }

    public void setPropertyToFieldMap(Map<String, Field> propertyToFieldMap) {
        this.propertyToFieldMap = propertyToFieldMap;
    }

    public String getSolrURL() {
        return this.solrURL;
    }

    public void setSolrURL(String solrURL) {
        this.solrURL = solrURL;
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public void setSolrHome(String solrHome) {
        File f = new File(solrHome);
        if (!f.isAbsolute()) {
            LOGGER.warn((Object)("Path to solrHome is not absolute [" + solrHome + "]. This may not work if solrHome is not properly fixed on server side."));
        } else {
            LOGGER.debug((Object)("Setting solrHome to a nice absolute path [" + solrHome + "]."));
        }
        this.solrHome = solrHome;
    }

    public String getSolrData() {
        return this.solrData;
    }

    public void setSolrData(String solrData) {
        File f = new File(solrData);
        if (!f.isAbsolute()) {
            LOGGER.warn((Object)("Path to solrData is not absolute [" + solrData + "]. This may not work if solrHome is not properly fixed on server side."));
        } else {
            LOGGER.debug((Object)("Setting solrData to a nice absolute path [" + solrData + "]."));
        }
        this.solrData = solrData;
    }

    public boolean isNoCore() {
        return this.noCore;
    }

    public void setNoCore(boolean noCore) {
        this.noCore = noCore;
    }
}

