/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr.analyser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.factory.AnnotationFactory;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.helper.impl.JenaResourceHelper;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.ComposedResource;
import org.ow2.weblab.core.model.Operator;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.services.solr.SolrComponent;
import org.ow2.weblab.services.solr.SolrConfig;
import org.ow2.weblab.util.SolrQueryParser;
import org.ow2.weblab.util.WebLabQueryParser;
import org.ow2.weblab.util.index.Field;

@WebService(endpointInterface="org.ow2.weblab.core.services.Analyser")
public class FacetSuggestion
implements Analyser {
    private static final String FILTER_TAG = "/filter";
    public static final String BEAN_NAME = "facetSuggestionServiceBean";
    public static final String IDRES_FACET_PREFIX = "facets";
    private static long suggestionCounter = 0L;
    private static long queryCounter = 0L;
    private Log logger;
    private SolrConfig conf;
    private Set<Field> facetFields;
    private Map<String, String> fieldToPropertyMap = new HashMap();
    private WebLabQueryParser parser;

    @PostConstruct
    public void init() {
        this.logger = LogFactory.getLog(FacetSuggestion.class);
        try {
            new URL(this.conf.getSolrURL());
        }
        catch (MalformedURLException e) {
            throw new WebLabUncheckedException("Cannot start the service. The solrULR is invalid [" + this.conf.getSolrURL() + "].", (Throwable)e);
        }
        this.parser = new SolrQueryParser(this.conf);
        for (Field f : this.facetFields) {
            if (f.getProperties() == null || f.getProperties().size() <= 0) continue;
            if (f.getEntityTypes() != null && f.getEntityTypes().size() > 0) {
                this.fieldToPropertyMap.put(f.getName(), f.getEntityTypes().get(0));
                continue;
            }
            this.fieldToPropertyMap.put(f.getName(), f.getProperties().get(0));
        }
    }

    @PreDestroy
    public void destroy() {
        this.logger.info((Object)"Destroying SolR FacetSuggestion service.");
    }

    public ProcessReturn process(ProcessArgs args) throws AccessDeniedException, UnexpectedException, InvalidParameterException, ContentNotAvailableException, InsufficientResourcesException, UnsupportedRequestException, ServiceNotConfiguredException {
        this.checkArgs(args);
        ResultSet enrichSet = this.doFacetSuggest(args.getUsageContext(), (ResultSet)args.getResource());
        ProcessReturn ret = new ProcessReturn();
        ret.setResource((Resource)enrichSet);
        return ret;
    }

    public ResultSet doFacetSuggest(String usageContext, ResultSet set) {
        try {
            if (!(set.getResource().get(0) instanceof Query)) {
                throw new WebLabCheckedException("There is no query in the ResultSet.");
            }
            Query query = (Query)set.getResource().get(0);
            ComposedResource cres = this.doFacetSuggest(usageContext, query);
            set.getResource().add(cres);
        }
        catch (WebLabCheckedException e) {
            this.logger.info((Object)("Cannot make spell suggestion : " + e.getMessage()));
        }
        return set;
    }

    public ComposedResource doFacetSuggest(String usageContext, Query query) {
        ComposedResource cres = (ComposedResource)ResourceFactory.createResource((String)"indexsearch.solr", (String)(IDRES_FACET_PREFIX + suggestionCounter++), ComposedResource.class);
        try {
            String request;
            QueryResponse response;
            SolrComponent instance = this.conf.isNoCore() ? SolrComponent.getInstance((SolrConfig)this.conf, null) : SolrComponent.getInstance((SolrConfig)this.conf, (String)usageContext);
            boolean ascOrder = false;
            String orderedByProperty = null;
            if (query.getAnnotation().size() > 0) {
                JenaResourceHelper hlpr = new JenaResourceHelper((Resource)query);
                ascOrder = this.parser.getOrder(query, (ResourceHelper)hlpr);
                orderedByProperty = this.parser.getOrderBy(query, (ResourceHelper)hlpr);
            }
            if ((response = instance.facetSuggest(request = this.parser.getRequest(query, (ResourceHelper)new JenaResourceHelper((Resource)query)), 0, 1, orderedByProperty, ascOrder ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc)).getFacetFields() == null || response.getFacetFields().size() == 0) {
                throw new WebLabCheckedException("There are no facets in the ResultSet.");
            }
            for (FacetField facet : response.getFacetFields()) {
                List countList = facet.getValues();
                if (countList == null) {
                    this.logger.debug((Object)("Facet " + facet.getName() + " is empty."));
                    continue;
                }
                for (FacetField.Count valuedFacet : countList) {
                    int nbRes = (int)valuedFacet.getCount();
                    if (nbRes == 0) {
                        this.logger.debug((Object)("Facet " + facet.getName() + ":" + valuedFacet.getName() + " is empty."));
                        continue;
                    }
                    Query facetQuery = this.createFacetQuery(query, 0, facet, nbRes, valuedFacet.getName());
                    cres.getResource().add(facetQuery);
                }
            }
            this.logger.info((Object)("Facet suggestion done for [" + query.getUri() + "]."));
        }
        catch (WebLabCheckedException e) {
            this.logger.info((Object)("Cannot make spell suggestion : " + e.getMessage()));
        }
        return cres;
    }

    private Query createFacetQuery(Query query, int offset, FacetField facet, int nbRes, String facetFilter) {
        String cQueryIdRes = "facetsquery" + queryCounter++;
        StringQuery facetQuery = (StringQuery)ResourceFactory.createResource((String)"indexsearch.solr", (String)(cQueryIdRes + FILTER_TAG), StringQuery.class);
        String scope = facet.getName();
        if (this.fieldToPropertyMap.containsKey(facet.getName())) {
            scope = (String)this.fieldToPropertyMap.get(facet.getName());
        }
        JenaPoKHelper hlpr = new JenaPoKHelper((PieceOfKnowledge)AnnotationFactory.createAndLinkAnnotation((Resource)facetQuery));
        hlpr.createResStat(facetQuery.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasScope", scope);
        hlpr.commit();
        if (facetFilter.contains(" ") && !facetFilter.contains("\"")) {
            facetFilter = "\"" + facetFilter + "\"";
        }
        facetQuery.setRequest(facetFilter);
        ComposedQuery cQuery = (ComposedQuery)ResourceFactory.createResource((String)"indexsearch.solr", (String)cQueryIdRes, ComposedQuery.class);
        cQuery.setOperator(Operator.AND);
        cQuery.getQuery().add(query);
        cQuery.getQuery().add(facetQuery);
        hlpr = new JenaPoKHelper((PieceOfKnowledge)AnnotationFactory.createAndLinkAnnotation((Resource)cQuery));
        hlpr.createLitStat(cQuery.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasNumberOfResults", Integer.toString(nbRes));
        hlpr.createLitStat(cQuery.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasQueryOffset", Integer.toString(offset));
        hlpr.createLitStat(cQuery.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#isExpressedWith", this.getClass().getSimpleName());
        hlpr.createLitStat(cQuery.getUri(), "http://www.w3.org/2000/01/rdf-schema#label", facetFilter);
        hlpr.createLitStat(cQuery.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasDescription", facetFilter);
        hlpr.createResStat(cQuery.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#isLinkedTo", query.getUri());
        hlpr.commit();
        return cQuery;
    }

    private void checkArgs(ProcessArgs args) throws InvalidParameterException {
        if (args == null) {
            throw new InvalidParameterException("Input args for [" + this.getClass().getSimpleName() + "] cannot be null.");
        }
    }

    public SolrConfig getConf() {
        return this.conf;
    }

    public void setConf(SolrConfig conf) {
        this.conf = conf;
    }

    public Set<Field> getFacetFields() {
        return this.facetFields;
    }

    public void setFacetFields(Set<Field> facetFields) {
        this.facetFields = facetFields;
    }
}

