/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr.searcher;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.factory.PoKFactory;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.helper.impl.JenaResourceHelper;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.SimilarityQuery;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.core.model.retrieval.WRetrievalAnnotator;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.Searcher;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.searcher.SearchArgs;
import org.ow2.weblab.core.services.searcher.SearchReturn;
import org.ow2.weblab.services.solr.SolrComponent;
import org.ow2.weblab.services.solr.SolrConfig;
import org.ow2.weblab.services.solr.analyser.FacetSuggestion;
import org.ow2.weblab.services.solr.analyser.Highlighter;
import org.ow2.weblab.services.solr.analyser.ResultSetMetadataEnrichment;
import org.ow2.weblab.util.SolrQueryParser;
import org.ow2.weblab.util.WebLabQueryParser;

@WebService(endpointInterface="org.ow2.weblab.core.services.Searcher")
public class SolrSearcher
implements Searcher {
    public static final String TO_BE_RANKED_BY = "http://weblab.ow2.org/core/1.2/ontology/retrieval#toBeRankedBy";
    public static final String TO_BE_RANKED_ASCENDING = "http://weblab.ow2.org/core/1.2/ontology/retrieval#toBeRankedAscending";
    public static final String HAS_SCOPE = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasScope";
    private static final String IS_RANKED_ASCENDING = "http://weblab.ow2.org/core/1.2/ontology/retrieval#isRankedAscending";
    public static final String BEAN_NAME = "searcherServiceBean";
    private static int resultsCounter = 0;
    private static int hitCounter = 0;
    private Log logger = LogFactory.getLog(SolrSearcher.class);
    private SolrConfig conf;
    private WebLabQueryParser parser;
    private ResultSetMetadataEnrichment enricher;
    private Highlighter highlighter;
    private FacetSuggestion facetSuggestion;

    @PostConstruct
    public void init() {
        try {
            SolrComponent.getInstance((SolrConfig)this.conf, null);
            if (this.conf == null) {
                // empty if block
            }
            this.parser = new SolrQueryParser(this.conf);
            new URL(this.conf.getSolrURL());
        }
        catch (WebLabCheckedException e) {
            throw new WebLabUncheckedException("Cannot start the SolrComponent.", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new WebLabUncheckedException("Cannot start the service. The solrULR is invalid [" + this.conf.getSolrURL() + "].", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
    }

    public SearchReturn search(SearchArgs arg) throws InvalidParameterException, ServiceNotConfiguredException, UnexpectedException {
        Query q = arg.getQuery();
        Integer offset = arg.getOffset() != null && arg.getOffset() > 0 ? arg.getOffset() : new Integer(0);
        Integer limit = arg.getLimit() != null && arg.getLimit() > 0 ? arg.getLimit() : Integer.valueOf(10);
        ResultSet set = this.search(arg.getUsageContext(), q, offset.intValue(), limit.intValue());
        if (this.enricher != null) {
            set = this.enricher.addMetadataToResultSet(arg.getUsageContext(), set);
        }
        if (this.highlighter != null) {
            set = this.highlighter.highLightHitInResultSet(arg.getUsageContext(), set);
        }
        if (this.facetSuggestion != null) {
            set = this.facetSuggestion.doFacetSuggest(arg.getUsageContext(), set);
        }
        SearchReturn re = new SearchReturn();
        re.setResultSet(set);
        return re;
    }

    public ResultSet search(String context, Query q, int offset, int limit) throws InvalidParameterException, ServiceNotConfiguredException, UnexpectedException {
        if (!(q instanceof StringQuery || q instanceof SimilarityQuery || q instanceof ComposedQuery)) {
            throw new InvalidParameterException("This service " + this.getClass().getSimpleName() + " can only process " + StringQuery.class.getSimpleName() + ", " + SimilarityQuery.class.getSimpleName() + " or " + ComposedQuery.class.getSimpleName() + ". Input has invalid type:" + q.getClass() == null ? " no xsi:type !" : q.getClass().getSimpleName());
        }
        try {
            if (q instanceof StringQuery) {
                this.logger.debug((Object)("String query request : " + ((StringQuery)q).getRequest()));
            } else if (q instanceof SimilarityQuery) {
                this.logger.debug((Object)("Sim query request : " + ((SimilarityQuery)q).getResource().size()));
            } else if (q instanceof ComposedQuery) {
                this.logger.debug((Object)("Composed query request containing " + ((ComposedQuery)q).getQuery().size() + " queries combined with " + ((ComposedQuery)q).getOperator()));
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Query input : " + ResourceUtil.saveToXMLString((Resource)q)));
            }
        }
        catch (WebLabCheckedException e) {
            this.logger.debug((Object)"Error when logging query input", (Throwable)e);
        }
        try {
            SolrComponent instance = this.conf.isNoCore() ? SolrComponent.getInstance((SolrConfig)this.conf, null) : SolrComponent.getInstance((SolrConfig)this.conf, (String)context);
            QueryResponse res = null;
            JenaResourceHelper hlpr = new JenaResourceHelper((Resource)q);
            boolean ascOrder = false;
            String orderedByProperty = null;
            if (q.getAnnotation().size() > 0) {
                ascOrder = this.parser.getOrder(q, (ResourceHelper)hlpr);
                orderedByProperty = this.parser.getOrderBy(q, (ResourceHelper)hlpr);
            }
            if (q instanceof StringQuery) {
                String theRequest = this.parser.getRequestWithScope((Query)((StringQuery)q), (ResourceHelper)hlpr);
                res = instance.search(theRequest, offset, limit, orderedByProperty, ascOrder ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
            } else if (q instanceof SimilarityQuery) {
                res = this.launchSimilarityQuery((SimilarityQuery)q, offset, limit, instance);
            } else if (q instanceof ComposedQuery) {
                res = instance.search(this.parser.getComposedRequest((ComposedQuery)q, (ResourceHelper)hlpr), offset, limit, orderedByProperty, ascOrder ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
            }
            SolrDocumentList resultDocs = res.getResults();
            int resCpt = 0;
            ResultSet results = (ResultSet)ResourceFactory.createResource((String)"indexsearch.solr", (String)("result" + resultsCounter++), ResultSet.class);
            results.getResource().add(q);
            URI queryURI = new URI(q.getUri());
            PieceOfKnowledge pok = PoKFactory.createAndLinkPoK((ResultSet)results);
            results.setPok(pok);
            WRetrievalAnnotator wra = new WRetrievalAnnotator(new URI(results.getUri()), pok);
            wra.writeType(new URI("http://weblab.ow2.org/core/1.2/ontology/model#ResultSet"));
            wra.writeResultOf(queryURI);
            wra.writeExpectedOffset(Integer.valueOf(offset));
            wra.writeExpectedLimit(Integer.valueOf(limit));
            if (ascOrder) {
                JenaPoKHelper hplr = new JenaPoKHelper(pok);
                hplr.createLitStat(results.getUri(), IS_RANKED_ASCENDING, "true");
            }
            if (resultDocs == null || resultDocs.getNumFound() == 0L) {
                wra.writeNumberOfResults(Integer.valueOf(0));
            } else {
                wra.writeNumberOfResults(Integer.valueOf((int)resultDocs.getNumFound()));
                for (SolrDocument hit : resultDocs) {
                    URI resourceUri = new URI(String.valueOf(hit.getFieldValue("id")));
                    URI hitUri = new URI("weblab://indexsearch.solr/hit" + hitCounter++);
                    wra.writeHit(hitUri);
                    wra.startInnerAnnotatorOn(hitUri);
                    wra.writeType(new URI("http://weblab.ow2.org/core/1.2/ontology/retrieval#Hit"));
                    wra.writeRank(Integer.valueOf(offset + resCpt + 1));
                    wra.writeScore(Double.valueOf(0.0 + (double)((Float)hit.getFieldValue("score")).floatValue()));
                    wra.writeLinkedTo(resourceUri);
                    wra.endInnerAnnotator();
                    ++resCpt;
                }
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Results input : " + ResourceUtil.saveToXMLString((Resource)results)));
            }
            return results;
        }
        catch (WebLabCheckedException e) {
            throw new InvalidParameterException("Cannot retrieve the results to query [" + q.getUri() + "] - " + e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new UnexpectedException("Invalid URI encountered during RDF annotation. That's really strange isn't it ?", (Throwable)e);
        }
    }

    private QueryResponse launchSimilarityQuery(SimilarityQuery q, int offset, int limit, SolrComponent instance) throws WebLabCheckedException {
        List resources = q.getResource();
        QueryResponse res = resources.size() == 1 ? instance.moreLikeThis(this.parser.getRequest((Query)q, (ResourceHelper)new JenaResourceHelper((Resource)q)), offset, limit) : instance.search(this.parser.getRequest((Query)q, (ResourceHelper)new JenaResourceHelper((Resource)q)), offset, limit);
        return res;
    }

    public ResultSetMetadataEnrichment getEnricher() {
        return this.enricher;
    }

    public void setEnricher(ResultSetMetadataEnrichment enricher) {
        this.enricher = enricher;
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        this.highlighter = highlighter;
    }

    public FacetSuggestion getFacetSuggestion() {
        return this.facetSuggestion;
    }

    public void setFacetSuggestion(FacetSuggestion facetSuggestion) {
        this.facetSuggestion = facetSuggestion;
    }

    public SolrConfig getConf() {
        return this.conf;
    }

    public void setConf(SolrConfig conf) {
        this.conf = conf;
    }
}

