/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.util;

import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.util.WebLabQueryParser;

public class SimpleQueryParser
extends WebLabQueryParser {
    public String getRequest(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        if (q instanceof StringQuery) {
            StringQuery squery = (StringQuery)q;
            return squery.getRequest();
        }
        if (q instanceof ComposedQuery) {
            ComposedQuery cquery = (ComposedQuery)q;
            return this.getComposedRequest(cquery, hlpr);
        }
        return null;
    }

    public String getComposedRequest(ComposedQuery q, ResourceHelper hlpr) throws WebLabCheckedException {
        StringBuffer queryString = new StringBuffer();
        queryString.append('(');
        for (Query subQ : q.getQuery()) {
            String rq;
            if (queryString.length() > 1) {
                queryString.append(' ');
            }
            if ((rq = this.getRequest(subQ, hlpr)) == null) continue;
            queryString.append(rq);
        }
        queryString.append(')');
        return queryString.toString();
    }

    public String getRequestWithScope(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        throw new WebLabCheckedException("Not implemented.");
    }

    public String getOrderBy(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        throw new WebLabCheckedException("Not implemented.");
    }

    public boolean getOrder(Query q, ResourceHelper hlpr) throws WebLabCheckedException {
        throw new WebLabCheckedException("Not implemented.");
    }
}

