/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.normaliser.tika.metadatawriter;

import java.net.URI;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.ow2.weblab.core.helper.PoKHelper;
import org.ow2.weblab.service.normaliser.tika.metadatawriter.MappingDescription;

public class MappingDescription {
    private URI annotation_URI;
    private Property propertyLinked;
    protected final Log logger = LogFactory.getLog(this.getClass());

    public MappingDescription(Property property, URI uri) {
        this.annotation_URI = uri;
        this.propertyLinked = property;
    }

    public void write(Metadata metadataToWrite, PoKHelper pokHelperToWriteInto, URI documentUri) {
        switch (1.$SwitchMap$org$apache$tika$metadata$Property$ValueType[this.propertyLinked.getValueType().ordinal()]) {
            case 1: {
                this.writeDate(metadataToWrite, pokHelperToWriteInto, documentUri);
                break;
            }
            case 2: {
                this.writeURI(metadataToWrite, pokHelperToWriteInto, documentUri);
                break;
            }
            default: {
                this.writeText(metadataToWrite, pokHelperToWriteInto, documentUri);
            }
        }
    }

    protected void writeText(Metadata metadataToWrite, PoKHelper pokHelperToWriteInto, URI documentUri) {
        String value_l = metadataToWrite.get(this.propertyLinked);
        if (!value_l.isEmpty()) {
            pokHelperToWriteInto.createLitStat(documentUri.toString(), this.annotation_URI.toString(), value_l);
        } else {
            this.logger.warn((Object)("Property " + this.propertyLinked.getName() + " was empty"));
        }
    }

    protected void writeURI(Metadata metadataToWrite, PoKHelper pokHelperToWriteInto, URI documentUri) {
        pokHelperToWriteInto.createResStat(documentUri.toString(), this.annotation_URI.toString(), metadataToWrite.get(this.propertyLinked));
    }

    protected void writeDate(Metadata metadataToWrite, PoKHelper pokHelperToWriteInto, URI documentUri) {
        Date localDate_l = metadataToWrite.getDate(this.propertyLinked);
        if (localDate_l == null) {
            this.logger.warn((Object)("Date property " + this.propertyLinked.getName() + " was null, setting to current date"));
        } else {
            DateTime dt = new DateTime((Object)localDate_l);
            pokHelperToWriteInto.createLitStat(documentUri.toString(), this.annotation_URI.toString(), ISODateTimeFormat.dateTime().print((ReadableInstant)dt));
        }
    }

    protected URI getAnnotation_URI() {
        return this.annotation_URI;
    }

    protected Property getPropertyLinked() {
        return this.propertyLinked;
    }
}

