package org.ow2.weblab.service.normaliser.tika.metadatawriter;

import java.net.URI;
import java.net.URISyntaxException;

import org.apache.tika.metadata.ClimateForcast;
import org.apache.tika.metadata.CreativeCommons;
import org.apache.tika.metadata.HttpHeaders;
import org.apache.tika.metadata.MSOffice;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.XMPDM;
import org.ow2.weblab.core.extended.ontologies.DCTerms;
import org.ow2.weblab.core.extended.ontologies.DublinCore;
import org.ow2.weblab.core.extended.ontologies.RDFS;

/**
 * Default implementation class of {@link MetadataWriter MetadataWriter}. It
 * contains a mapping for several standard properties from DublinCore annotation
 * sets.
 * 
 * @author Frédéric Praca
 * @see MetadataWriter
 * @see org.ow2.weblab.core.helper.PoKHelper
 * @see org.apache.tika.metadata.Metadata
 * @see MappingDescription
 */
public class DefaultMetaDataWriter extends MetadataWriter {

	public DefaultMetaDataWriter() {
		super();
	}

	@Override
	protected void init() {
		try {
			addMapping(
					ClimateForcast.CONTACT,
					new MappingDescription(Property
							.externalText(ClimateForcast.CONTACT), new URI(
							DublinCore.CONTRIBUTOR_PROPERTY_NAME)));

			addMapping(ClimateForcast.INSTITUTION, new MappingDescription(
					Property.externalText(ClimateForcast.INSTITUTION), new URI(
							DublinCore.CONTRIBUTOR_PROPERTY_NAME)));

			addMapping(ClimateForcast.REFERENCES, new MappingDescription(
					Property.externalText(ClimateForcast.REFERENCES), new URI(
							DCTerms.REFERENCES)));

			addMapping(
					ClimateForcast.SOURCE,
					new MappingDescription(Property
							.externalText(ClimateForcast.SOURCE), new URI(
							DublinCore.SOURCE_PROPERTY_NAME)));

			addMapping(
					CreativeCommons.LICENSE_LOCATION,
					new MappingDescription(Property
							.externalText(CreativeCommons.LICENSE_LOCATION),
							new URI(DCTerms.LICENSE)));

			addMapping(
					org.apache.tika.metadata.DublinCore.CONTRIBUTOR,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.CONTRIBUTOR),
							new URI(DublinCore.CONTRIBUTOR_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.COVERAGE,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.COVERAGE),
							new URI(DublinCore.CREATOR_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.CREATOR,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.CREATOR),
							new URI(DublinCore.CREATOR_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.DESCRIPTION,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.DESCRIPTION),
							new URI(DublinCore.DESCRIPTION_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.FORMAT,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.FORMAT),
							new URI(DublinCore.FORMAT_PROPERTY_NAME)));
			
			addMapping(
					org.apache.tika.metadata.Metadata.CONTENT_TYPE,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.Metadata.CONTENT_TYPE),
							new URI(DublinCore.FORMAT_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.IDENTIFIER,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.IDENTIFIER),
							new URI(DublinCore.IDENTIFIER_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.LANGUAGE,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.LANGUAGE),
							new URI(DublinCore.LANGUAGE_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.MODIFIED,
					new MappingDescription(
							Property.externalDate(org.apache.tika.metadata.DublinCore.MODIFIED),
							new URI(DCTerms.MODIFIED)));

			addMapping(
					org.apache.tika.metadata.DublinCore.PUBLISHER,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.PUBLISHER),
							new URI(DublinCore.PUBLISHER_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.RELATION,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.RELATION),
							new URI(DublinCore.RELATION_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.RIGHTS,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.RIGHTS),
							new URI(DublinCore.RIGHTS_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.SOURCE,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.SOURCE),
							new URI(DublinCore.SOURCE_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.SUBJECT,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.SUBJECT),
							new URI(DublinCore.SUBJECT_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.TITLE,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.TITLE),
							new URI(DublinCore.TITLE_PROPERTY_NAME)));

			addMapping(
					org.apache.tika.metadata.DublinCore.TYPE,
					new MappingDescription(
							Property.externalText(org.apache.tika.metadata.DublinCore.TYPE),
							new URI(DublinCore.TYPE_PROPERTY_NAME)));

			addMapping(org.apache.tika.metadata.DublinCore.DATE.getName(),
					new MappingDescription(
							org.apache.tika.metadata.DublinCore.DATE, new URI(
									DublinCore.DATE_PROPERTY_NAME)));

			addMapping(HttpHeaders.LAST_MODIFIED.getName(),
					new MappingDescription(HttpHeaders.LAST_MODIFIED, new URI(
							DCTerms.MODIFIED)));

			addMapping(
					Message.MESSAGE_FROM,
					new MappingDescription(Property
							.externalText(Message.MESSAGE_FROM), new URI(
							DublinCore.CREATOR_PROPERTY_NAME)));

			addMapping(
					MSOffice.AUTHOR,
					new MappingDescription(Property
							.externalText(MSOffice.AUTHOR), new URI(
							DublinCore.CREATOR_PROPERTY_NAME)));

			addMapping(MSOffice.CHARACTER_COUNT.getName(),
					new MappingDescriptionWithUnit(MSOffice.CHARACTER_COUNT,
							new URI(DCTerms.EXTENT), " characters"));

			addMapping(MSOffice.CHARACTER_COUNT_WITH_SPACES.getName(),
					new MappingDescriptionWithUnit(
							MSOffice.CHARACTER_COUNT_WITH_SPACES, new URI(
									DCTerms.EXTENT),
							" characters (with spaces)"));

			addMapping(
					MSOffice.COMMENTS,
					new MappingDescription(Property
							.externalText(MSOffice.COMMENTS), new URI(
							RDFS.COMMENT)));

			addMapping(
					MSOffice.COMPANY,
					new MappingDescription(Property
							.externalText(MSOffice.COMPANY), new URI(
							DublinCore.CONTRIBUTOR_PROPERTY_NAME)));

			addMapping(
					MSOffice.KEYWORDS,
					new MappingDescription(Property
							.externalText(MSOffice.KEYWORDS), new URI(
							DublinCore.DESCRIPTION_PROPERTY_NAME)));

			addMapping(
					MSOffice.LAST_AUTHOR,
					new MappingDescription(Property
							.externalText(MSOffice.LAST_AUTHOR), new URI(
							DublinCore.CONTRIBUTOR_PROPERTY_NAME)));

			addMapping(MSOffice.LINE_COUNT.getName(),
					new MappingDescriptionWithUnit(MSOffice.LINE_COUNT,
							new URI(DublinCore.CONTRIBUTOR_PROPERTY_NAME),
							" lines"));

			addMapping(
					MSOffice.MANAGER,
					new MappingDescription(Property
							.externalText(MSOffice.MANAGER), new URI(
							DublinCore.CONTRIBUTOR_PROPERTY_NAME)));

			addMapping(
					MSOffice.NOTES,
					new MappingDescription(Property
							.externalText(MSOffice.NOTES),
							new URI(RDFS.COMMENT)));

			addMapping(MSOffice.PAGE_COUNT.getName(),
					new MappingDescriptionWithUnit(MSOffice.PAGE_COUNT,
							new URI(DCTerms.EXTENT), " pages"));

			addMapping(MSOffice.PARAGRAPH_COUNT.getName(),
					new MappingDescriptionWithUnit(MSOffice.PARAGRAPH_COUNT,
							new URI(DCTerms.EXTENT), " paragraphs"));

			addMapping(MSOffice.SLIDE_COUNT.getName(),
					new MappingDescriptionWithUnit(MSOffice.SLIDE_COUNT,
							new URI(DCTerms.EXTENT), " slides"));

			addMapping(MSOffice.WORD_COUNT.getName(),
					new MappingDescriptionWithUnit(MSOffice.WORD_COUNT,
							new URI(DCTerms.EXTENT), " words"));

			addMapping(MSOffice.CREATION_DATE.getName(),
					new MappingDescription(MSOffice.CREATION_DATE, new URI(
							DCTerms.CREATED)));

			addMapping(MSOffice.LAST_SAVED.getName(), new MappingDescription(
					MSOffice.LAST_SAVED, new URI(DCTerms.MODIFIED)));

			addMapping(PagedText.N_PAGES.getName(),
					new MappingDescriptionWithUnit(PagedText.N_PAGES, new URI(
							DCTerms.EXTENT), " pages"));

			addMapping(TIFF.ORIGINAL_DATE.getName(), new MappingDescription(
					TIFF.ORIGINAL_DATE, new URI(DCTerms.CREATED)));

			addMapping(XMPDM.ARTIST.getName(),
					new MappingDescription(XMPDM.ARTIST, new URI(
							DublinCore.CONTRIBUTOR_PROPERTY_NAME)));

			addMapping(XMPDM.AUDIO_MOD_DATE.getName(), new MappingDescription(
					XMPDM.AUDIO_MOD_DATE, new URI(DCTerms.MODIFIED)));

			addMapping(XMPDM.COMPOSER.getName(), new MappingDescription(
					XMPDM.COMPOSER, new URI(
							DublinCore.CONTRIBUTOR_PROPERTY_NAME)));

			addMapping(XMPDM.COPYRIGHT.getName(), new MappingDescription(
					XMPDM.COPYRIGHT, new URI(DublinCore.RIGHTS_PROPERTY_NAME)));

			addMapping(XMPDM.ENGINEER.getName(), new MappingDescription(
					XMPDM.ENGINEER, new URI(
							DublinCore.CONTRIBUTOR_PROPERTY_NAME)));

			addMapping(XMPDM.GENRE.getName(), new MappingDescription(
					XMPDM.GENRE, new URI(DublinCore.DESCRIPTION_PROPERTY_NAME)));

			addMapping(XMPDM.LOG_COMMENT.getName(), new MappingDescription(
					XMPDM.LOG_COMMENT, new URI(RDFS.COMMENT)));

			addMapping(XMPDM.METADATA_MOD_DATE.getName(),
					new MappingDescription(XMPDM.METADATA_MOD_DATE, new URI(
							DCTerms.MODIFIED)));

			addMapping(XMPDM.RELEASE_DATE.getName(), new MappingDescription(
					XMPDM.RELEASE_DATE, new URI(DCTerms.AVAILABLE)));

			addMapping(XMPDM.SHOT_DATE.getName(), new MappingDescription(
					XMPDM.SHOT_DATE, new URI(DCTerms.CREATED)));

			addMapping(XMPDM.SHOT_DATE.getName(), new MappingDescription(
					XMPDM.SHOT_DATE, new URI(DCTerms.CREATED)));
		} catch (URISyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
