package org.ow2.weblab.service.normaliser.tika.metadatawriter;

import java.net.URI;

import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.ow2.weblab.core.helper.PoKHelper;

/**
 * This subclass of {@link MappingDescription MappingDescription} allows to
 * specify a unit that will be added at the end of the text value.
 * 
 * @author Frédéric Praca
 * 
 */
public class MappingDescriptionWithUnit extends MappingDescription {

	private String unit;

	/**
	 * Constructor that take an additional parameter compared to its base class
	 * {@link MappingDescription MappingDescription}. This parameter is simply a
	 * String object containing the unit that will be added at the end of the
	 * property value.
	 * 
	 * @param property
	 *            the Tika property to map
	 * @param uri
	 *            The URI representing the mapping
	 * @param unit
	 *            The unit used as String
	 * 
	 */
	public MappingDescriptionWithUnit(final Property property, final URI uri,
			final String unit) {
		super(property, uri);
		this.unit = unit;
	}

	@Override
	protected void writeText(Metadata metadataToWrite,
			PoKHelper pokHelperToWriteInto, URI documentUri) {
		String value_l = metadataToWrite.get(getPropertyLinked());
		if (!value_l.isEmpty()) {
			pokHelperToWriteInto.createLitStat(documentUri.toString(),
					getAnnotation_URI().toString(),
					value_l.concat(" ").concat(unit));
		} else {
			logger.warn("Value for property " + getPropertyLinked().getName() + " was null");
		}
	}
}
