/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.normaliser.tika.metadatawriter;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.metadata.Metadata;
import org.ow2.weblab.core.helper.PoKHelper;
import org.ow2.weblab.service.normaliser.tika.metadatawriter.MappingDescription;

public abstract class MetadataWriter {
    protected final Log logger;
    private Map<String, MappingDescription> mappingMap = new HashMap();

    public MetadataWriter() {
        this.logger = LogFactory.getLog(this.getClass());
        this.init();
    }

    public void write(Metadata metadataToWrite, PoKHelper pokHelperToWriteInto, URI documentUri) {
        for (String name : metadataToWrite.names()) {
            MappingDescription desc_l = (MappingDescription)this.mappingMap.get(name);
            if (desc_l != null) {
                this.logger.trace((Object)("Writing " + name + " property into " + desc_l.getAnnotation_URI().toASCIIString()));
                desc_l.write(metadataToWrite, pokHelperToWriteInto, documentUri);
                continue;
            }
            this.writeUnmmappedMetadata(metadataToWrite, name, pokHelperToWriteInto, documentUri);
        }
    }

    protected void addMapping(String propertyToMap, MappingDescription toDescription) {
        this.mappingMap.put(propertyToMap, toDescription);
    }

    protected abstract void init();

    protected void writeUnmmappedMetadata(Metadata metadataToWrite, String name, PoKHelper pokHelperToWriteInto, URI documentUri) {
        this.logger.debug((Object)("Property " + name + " is not currently mapped, value found : " + metadataToWrite.get(name)));
    }
}

