/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.service.normaliser.tika;

import java.net.URI;
import org.ow2.weblab.service.normaliser.tika.handlers.SimpleTextContentHandler;
import org.ow2.weblab.service.normaliser.tika.handlers.WebLabHandlerDecorator;

public class TikaConfiguration {
    public static final String UNMAPPED_PROPERTIES_BASE_URI = "http://tika.apache.org/property#";
    public static final String UNMAPPED_PROPERTIES_PREFIX = "tika";
    public static final Class<? extends WebLabHandlerDecorator> WEBLAB_HANDLER_DECORATOR = SimpleTextContentHandler.class;
    private String pathToXmlConfigurationFile;
    private boolean addMetadata;
    private boolean addUnmappedProperties;
    private boolean annotateDocumentWithLang;
    private String defaultLang;
    private boolean generateHtml;
    private boolean overrideMetadata;
    private boolean removeTempContent;
    private URI serviceUri;
    private String unmappedPropertiesBaseUri;
    private String unmappedPropertiesPrefix;
    private Class<? extends WebLabHandlerDecorator> webLabHandlerDecoratorClass;

    public String getPathToXmlConfigurationFile() {
        return this.pathToXmlConfigurationFile;
    }

    public void setPathToXmlConfigurationFile(String pathToXmlConfigurationFile) {
        this.pathToXmlConfigurationFile = pathToXmlConfigurationFile;
    }

    public void setServiceUri(URI serviceUri) {
        this.serviceUri = serviceUri;
    }

    public String getDefaultLang() {
        return this.defaultLang;
    }

    public String getServiceUri() {
        if (this.serviceUri == null) {
            return null;
        }
        return this.serviceUri.toString();
    }

    public String getUnmappedPropertiesBaseUri() {
        if (this.unmappedPropertiesBaseUri == null || this.unmappedPropertiesBaseUri.isEmpty()) {
            return UNMAPPED_PROPERTIES_BASE_URI;
        }
        return this.unmappedPropertiesBaseUri;
    }

    public String getUnmappedPropertiesPrefix() {
        if (this.unmappedPropertiesPrefix == null || this.unmappedPropertiesPrefix.isEmpty()) {
            return UNMAPPED_PROPERTIES_PREFIX;
        }
        return this.unmappedPropertiesPrefix;
    }

    public Class<? extends WebLabHandlerDecorator> getWebLabHandlerDecoratorClass() {
        if (this.webLabHandlerDecoratorClass == null) {
            return WEBLAB_HANDLER_DECORATOR;
        }
        return this.webLabHandlerDecoratorClass;
    }

    public boolean isAddMetadata() {
        return this.addMetadata;
    }

    public boolean isAddUnmappedProperties() {
        return this.addUnmappedProperties;
    }

    public boolean isAnnotateDocumentWithLang() {
        return this.annotateDocumentWithLang;
    }

    public boolean isGenerateHtml() {
        return this.generateHtml;
    }

    public boolean isOverrideMetadata() {
        return this.overrideMetadata;
    }

    public boolean isRemoveTempContent() {
        return this.removeTempContent;
    }

    public void setAddMetadata(boolean addMetadata) {
        this.addMetadata = addMetadata;
    }

    public void setAddUnmappedProperties(boolean addUnmappedProperties) {
        this.addUnmappedProperties = addUnmappedProperties;
    }

    public void setAnnotateDocumentWithLang(boolean annotateDocumentWithLang) {
        this.annotateDocumentWithLang = annotateDocumentWithLang;
    }

    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public void setGenerateHtml(boolean generateHtml) {
        this.generateHtml = generateHtml;
    }

    public void setOverrideMetadata(boolean overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
    }

    public void setRemoveTempContent(boolean removeTempContent) {
        this.removeTempContent = removeTempContent;
    }

    public void setServiceUri(String serviceUri) {
        this.serviceUri = serviceUri == null || serviceUri.isEmpty() ? null : URI.create(serviceUri);
    }

    public void setUnmappedPropertiesBaseUri(String unmappedPropertiesBaseUri) {
        this.unmappedPropertiesBaseUri = unmappedPropertiesBaseUri;
    }

    public void setUnmappedPropertiesPrefix(String unmappedPropertiesPrefix) {
        this.unmappedPropertiesPrefix = unmappedPropertiesPrefix;
    }

    public void setWebLabHandlerDecoratorClass(Class<? extends WebLabHandlerDecorator> webLabHandlerDecoratorClass) {
        this.webLabHandlerDecoratorClass = webLabHandlerDecoratorClass;
    }
}

