/**
 *	This file is part of org.ow2.wildcat.
 *
 *	wildcat is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	wildcat is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 */
package org.ow2.wildcat.event;

import java.util.Map;

import org.ow2.wildcat.hierarchy.Path;

/**
 * WAttributeEvent holds events related to an attribute value change
 */
public class WAttributeEvent extends WEvent implements WEventInterface {

	/**
	 * Id for serializable class.
	 */
	private static final long serialVersionUID = 8380838667374681500L;

	/**
	 * The new value of the attribtue
	 */
	protected Object value;

	/**
	 * Constructor.
	 *
	 * @param source
	 *            the location of the attribute
	 * @param value
	 *            the new value of the attribute
	 */
	public WAttributeEvent(final Path source, final Object value) {
		super(source);
		this.value = value;
	}

	/**
	 * POJO-style getter.
	 *
	 * @return the attribute new value
	 */
	public Object getValue() {
		return this.value;
	}

	/**
	 * Map-style getter.
	 *
	 * @param key
	 *            map key
	 * @return Map value or <b>null</b> if key is not associated
	 */
	@SuppressWarnings("unchecked")
	public Object getValue(final String key) {
		return ((Map<String, Object>) this.value).get(key);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.ow2.wildcat.event.WEvent#toString()
	 */
	@Override
	public String toString() {
		return super.toString() + " ---> " + this.value;
	}

}
