/**
 *	This file is part of org.ow2.wildcat.
 *
 *	wildcat is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	wildcat is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 */
package org.ow2.wildcat.event;

import org.ow2.wildcat.hierarchy.Path;

/**
 * Event without arguments
 */
public class WEvent implements WEventInterface {

	/**
	 * Id for serializable class.
	 */
	private static final long serialVersionUID = -8737934846415830472L;

	/**
	 * The source of the Event
	 */
	protected Path source;

	/**
	 * Constructors
	 *
	 * @param source
	 *            origin of the event
	 */
	public WEvent(final Path source) {
		this.source = source;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.ow2.wildcat.event.WEventInterface#getSource()
	 */
	public String getSource() {
		return this.source.toString();
	}

	/**
	 * Setter.
	 *
	 * @param path
	 */
	public void setSource(final Path path) {
		this.source = path;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "^@(" + this.source.toString() + ")";
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

}
