/**
 *	This file is part of org.ow2.wildcat.
 *
 *	wildcat is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	wildcat is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 */
package org.ow2.wildcat.event;

import org.ow2.wildcat.hierarchy.Path;

/**
 * WHierarchyEvent holds events related to the context hierarchy changes
 */
public class WHierarchyEvent extends WEvent implements WEventInterface {


	/**
	 * Id for serializable class.
	 */
	private static final long serialVersionUID = 8748148191888782826L;

	/**
	 * The type of operation
	 */
	protected Type type;

	/**
	 * The object of the operation (ie: a resource or an attribute name)
	 */
	protected String target;

	/**
	 * Constructor.
	 *
	 * @param source
	 *            location at which the event was fired
	 * @param type
	 *            the type of change in the hierarchy
	 * @param target
	 *            the object of the change
	 */
	public WHierarchyEvent(final Path source, final Type type, final String target) {
		super(source);
		this.type = type;
		this.target = target;
	}

	/**
	 * Getter.
	 *
	 * @return the type of change in the hierarchy
	 */
	public Type getType() {
		return this.type;
	}

	/**
	 * Getter.
	 *
	 * @return the subject of the event
	 */
	public String getTarget() {
		return this.target;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return super.toString() + ": " + this.type.toString() + " "
		+ this.target;
	}

	/**
	 * The types of events
	 */
	public enum Type {
		RESOURCE_ADDED, RESOURCE_REMOVED, ATTRIBUTE_ADDED, ATTRIBUTE_REMOVED, LINKED, UNLINKED,
	}
}
