/**
 *	This file is part of org.ow2.wildcat.
 *
 *	wildcat is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	wildcat is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 */
package org.ow2.wildcat.hierarchy;

/**
 * Exception thrown when a {@link Path} is not conform at he specification.
 */
public class MalformedPathException extends Exception {

	/**
	 * Id for serializable class.
	 */
	private static final long serialVersionUID = 3012043867093286600L;

	public MalformedPathException() {
		super();
	}

	public MalformedPathException(final String message, final Throwable cause) {
		super(message, cause);
	}

	public MalformedPathException(final Throwable cause) {
		super(cause);
	}

	public MalformedPathException(final String message) {
		super(message);
	}

}
