/**
 *	This file is part of org.ow2.wildcat.
 *
 *	wildcat is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	wildcat is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 */
package org.ow2.wildcat.hierarchy;

import org.ow2.wildcat.Context;

/**
 * Interface that Resources and Attributes must implement.
 */
public interface Mountable {

	/**
	 * @return <b>true</b> if is mount, <b>false</b> else.
	 */
	public boolean isMount();

	/**
	 * Mount the Mountable.
	 *
	 * @param context
	 *            the context the Mountable is attached
	 * @param mountPoint
	 *            the path to mount it
	 */
	public void mount(Context context, Path mountPoint);

	/**
	 * Unmount the Mountable.
	 */
	public void unMount();
}
