/**
 * WildCAT
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ResourceException.java 334 2008-09-05 17:14:19Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.hierarchy.resource;

/**
 * Exception thrown when an operation on a resource failed.
 * @author Loris Bouzonnet
 */
public class ResourceException extends Exception {

	/**
	 * Id for serializable class.
	 */
	private static final long serialVersionUID = -2624215603585244921L;

	public ResourceException() {
	}

	public ResourceException(final String message) {
		super(message);
	}

	public ResourceException(final Throwable cause) {
		super(cause);
	}

	public ResourceException(final String message, final Throwable cause) {
		super(message, cause);
	}

}
