/**
 * WildCAT
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IQueryAdder.java 330 2008-09-03 17:03:41Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.osgi.api;

import org.ow2.wildcat.Context;
import org.ow2.wildcat.Query;
import org.ow2.wildcat.hierarchy.ListenerRegistrationException;

import net.esper.client.UpdateListener;

/**
 * Service providing an event query and an associated listener.
 * @author Loris Bouzonnet
 */
public interface IQueryAdder {

    /**
     * Add a query and an associated listener to the given context.
     * @param context a context
     * @return the added query
     * @throws ListenerRegistrationException if the registration failed
     */
    Query registerListener(Context context) throws ListenerRegistrationException;

    /**
     * @return an event query
     */
    String getQuery();

    /**
     * @return a listener
     */
    UpdateListener getListener();

}
