/**
 *	This file is part of org.ow2.wildcat.
 *
 *	wildcat is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	wildcat is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 */
package org.ow2.wildcat.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Date and Time helper class.
 */
public class TimeUtil {

	private static final SimpleDateFormat FORMAT = new SimpleDateFormat(
	"yyyy-MM-dd'T'HH:mm:ssZ");

	/**
	 * Format a timestamp into a human readable String.
	 *
	 * @param timeStamp
	 *            a timestamp
	 * @return a String representation of the timestamp according to
	 *         {@link TimeUtil#FORMAT}
	 */
	public static String format(final long timeStamp) {
		return FORMAT.format(new Date(timeStamp));
	}

	/**
	 * Compute a timestamp from a human readable String.
	 *
	 * @param date
	 *            a Date and Time in a String representation
	 * @return a timestamp
	 * @throws ParseException
	 *             if <b>date</b> can't be parsed according to
	 *             {@link TimeUtil#FORMAT}
	 */
	public static long parse(final String date) throws ParseException {
		return FORMAT.parse(date).getTime();
	}

	/**
	 * Get current time timestamp.
	 *
	 * @return current timestamp
	 */
	public static long now() {
		return System.currentTimeMillis();
	}
}
