/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 * --------------------------------------------------------------------------
 * $Id: WHierarchyEvent.java 366 2008-12-10 18:50:44Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.event;

import org.ow2.wildcat.hierarchy.Path;

/**
 * WHierarchyEvent holds events related to the context hierarchy changes.
 */
public class WHierarchyEvent extends WEvent implements WEventInterface {


    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 8748148191888782826L;

    /**
     * The type of operation
     */
    protected Type type;

    /**
     * The object of the operation (ie: a resource or an attribute name)
     */
    protected String target;

    /**
     * Constructor.
     *
     * @param source
     *            location at which the event was fired
     * @param type
     *            the type of change in the hierarchy
     * @param target
     *            the object of the change
     */
    public WHierarchyEvent(final Path source, final Type type, final String target) {
        super(source);
        this.type = type;
        this.target = target;
    }

    /**
     * Getter.
     *
     * @return the type of change in the hierarchy
     */
    public Type getType() {
        return this.type;
    }

    /**
     * Getter.
     *
     * @return the subject of the event
     */
    public String getTarget() {
        return this.target;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return super.toString() + ": " + this.type.toString() + " "
        + this.target;
    }

    /**
     * The types of events
     */
    public enum Type {
        RESOURCE_ADDED, RESOURCE_REMOVED, ATTRIBUTE_ADDED, ATTRIBUTE_REMOVED, LINKED, UNLINKED,
    }
}
