/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 * --------------------------------------------------------------------------
 * $Id: Mountable.java 366 2008-12-10 18:50:44Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.hierarchy;

import org.ow2.wildcat.Context;

/**
 * Interface that Resources and Attributes must implement.
 */
public interface Mountable {

    /**
     * @return <b>true</b> if is mount, <b>false</b> else.
     */
    public boolean isMount();

    /**
     * Mount the Mountable.
     *
     * @param context
     *            the context the Mountable is attached
     * @param mountPoint
     *            the path to mount it
     */
    public void mount(Context context, Path mountPoint);

    /**
     * Unmount the Mountable.
     */
    public void unMount();
}
