/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * --------------------------------------------------------------------------
 * $Id: IQueryAdder.java 366 2008-12-10 18:50:44Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.osgi.api;

import org.ow2.wildcat.Context;
import org.ow2.wildcat.Query;
import org.ow2.wildcat.hierarchy.ListenerRegistrationException;

import net.esper.client.UpdateListener;

/**
 * Service providing an event query and an associated listener.
 * @author Loris Bouzonnet
 */
public interface IQueryAdder {

    /**
     * Add a query and an associated listener to the given context.
     * @param context a context
     * @return the added query
     * @throws ListenerRegistrationException if the registration failed
     */
    Query registerListener(Context context) throws ListenerRegistrationException;

    /**
     * @return an event query
     */
    String getQuery();

    /**
     * @return a listener
     */
    UpdateListener getListener();

}
