/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 * --------------------------------------------------------------------------
 * $Id: WEvent.java 350 2008-11-10 09:41:14Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.event;

import org.ow2.wildcat.hierarchy.Path;

/**
 * Event without arguments.
 */
public class WEvent implements WEventInterface {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = -8737934846415830472L;

    /**
     * The source of the Event
     */
    protected Path source;

    /**
     * Constructors
     *
     * @param source
     *            origin of the event
     */
    public WEvent(final Path source) {
        this.source = source;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.wildcat.event.WEventInterface#getSource()
     */
    public String getSource() {
        return this.source.toString();
    }

    /**
     * Setter.
     *
     * @param path
     */
    public void setSource(final Path path) {
        this.source = path;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "^@(" + this.source.toString() + ")";
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#clone()
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

}
