/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 * --------------------------------------------------------------------------
 * $Id: POJOAttribute.java 350 2008-11-10 09:41:14Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.hierarchy.attribute;

import java.io.Serializable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.event.WAttributeEvent;
import org.ow2.wildcat.hierarchy.Mountable;
import org.ow2.wildcat.hierarchy.Path;
import org.ow2.wildcat.util.Messages;

/**
 * Attribute holding an object.
 */
public class POJOAttribute implements Attribute, Serializable {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = -4196980811813274873L;

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(POJOAttribute.class);

    protected Context context = null;
    protected Path path = null;

    protected Object value;

    public POJOAttribute(final Object value) {
        this.value = value;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.wildcat.hierarchy.Attribute#getValue()
     */
    public Object getValue() {
        return this.value;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.wildcat.hierarchy.Attribute#setValue(java.lang.Object)
     */
    public Object setValue(final Object value) {
        Object old = this.value;
        this.value = value;
        if (this.isMount()) {
            this.context.emitEvent(new WAttributeEvent(this.path, this.value));
        }
        return old;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.wildcat.hierarchy.Mountable#isMount()
     */
    public boolean isMount() {
        return this.context != null && this.path != null;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.wildcat.hierarchy.Mountable#mount(org.ow2.wildcat.Context,
     *      org.ow2.wildcat.hierarchy.Path)
     */
    public void mount(final Context context, final Path mountPoint) {
        logger.debug(Messages.message(Mountable.class.getName() + ".mount",
                mountPoint));

        if (this.isMount()) {
            logger.info(Messages.message(Mountable.class.getName()
                    + ".alreadymount", mountPoint));
        } else {
            this.context = context;
            this.path = mountPoint;
        }
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.wildcat.hierarchy.Mountable#unMount()
     */
    public void unMount() {
        logger.debug(Messages.message(Mountable.class.getName() + ".unmount",
                (Object[]) null));

        this.context = null;
        this.path = null;
    }

}
