/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 * --------------------------------------------------------------------------
 * $Id: Messages.java 350 2008-11-10 09:41:14Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Helper class to handle logging messages.
 */
public final class Messages {

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(Messages.class);

    /**
     * Singleton.
     */
    private static Messages WILDCAT;

    /**
     * The configuration.
     */
    private Properties properties;

    /**
     * Initialize the formatter of messages.
     * @param resource a filename to load the configuration
     */
    public static void init(final String resource) {
        if(WILDCAT == null) {
            WILDCAT = new Messages(resource);
        }
    }

    private Messages(final String resource) {
        this.properties = new Properties();
        try {
            this.properties.load(getClass().getResourceAsStream(resource));
        } catch (IOException e) {
            logger.warn("Could not fetch messages file \'" + resource + "\'");
            this.properties = null;
        }
    }

    private static String getMessage(final String key) {
        if (WILDCAT == null || WILDCAT.properties == null) {
            return "! " + key + " !";
        } else {
            return WILDCAT.properties.getProperty(key, "! " + key + " !");
        }
    }

    /**
     * Formats a message referenced by key with its arguments.
     *
     * @param key
     *            reference of the message
     * @param args
     *            optional arguments
     * @return a formatted String
     */
    public static String message(final String key, final Object... args) {
        return MessageFormat.format(getMessage(key), args);
    }
}
