/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.hierarchy.attribute;

import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.event.EventBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.Query;
import org.ow2.wildcat.event.WAttributeEvent;
import org.ow2.wildcat.event.WEventInterface;
import org.ow2.wildcat.hierarchy.Mountable;
import org.ow2.wildcat.hierarchy.Path;
import org.ow2.wildcat.hierarchy.attribute.Attribute;
import org.ow2.wildcat.util.Messages;

public class QueryAttribute
implements Attribute,
UpdateListener {
    private static Log logger = LogFactory.getLog(QueryAttribute.class);
    private final String queryString;
    private final WEventInterface.Scope scope;
    private Query query;
    private Object value;
    private Context context;
    private Path path;

    public QueryAttribute(String queryString) {
        this(queryString, WEventInterface.Scope.GLOBAL);
    }

    public QueryAttribute(String queryString, WEventInterface.Scope scope) {
        this.queryString = queryString;
        this.scope = scope;
    }

    public Object getValue() {
        return this.value;
    }

    public Object setValue(Object value) {
        return this.value;
    }

    protected WEventInterface.Scope getScope() {
        return this.scope;
    }

    protected Context getContext() {
        return this.context;
    }

    protected Path getPath() {
        return this.path;
    }

    public boolean isMount() {
        return this.context != null && this.path != null;
    }

    public void mount(Context context, Path mountPoint) {
        logger.debug((Object)Messages.message(Mountable.class.getName() + ".mount", mountPoint));
        if (this.isMount()) {
            logger.info((Object)Messages.message(Mountable.class.getName() + ".alreadymount", mountPoint));
        } else {
            this.context = context;
            this.path = mountPoint;
            this.query = this.context.registerListeners(this.queryString, this);
        }
    }

    public void unMount() {
        logger.debug((Object)Messages.message(Mountable.class.getName() + ".unmount", null));
        if (this.isMount() && this.query != null) {
            this.context.destroyQuery(this.query);
        }
        this.query = null;
        this.context = null;
        this.path = null;
    }

    public void update(EventBean[] newEvents, EventBean[] oldEvents) {
        if (newEvents == null || newEvents.length == 0) {
            this.value = null;
        } else if (newEvents.length == 1) {
            this.value = newEvents[0].getUnderlying();
        } else {
            Object[] oa = new Object[newEvents.length];
            for (int i = 0; i < newEvents.length; ++i) {
                oa[i] = newEvents[i].getUnderlying();
            }
            this.value = oa;
        }
        if (this.isMount()) {
            this.context.emitEvent(new WAttributeEvent(this.path, this.scope, this.value));
        }
    }
}

