/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 * --------------------------------------------------------------------------
 * $Id: Query.java 398 2009-01-02 10:53:18Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat;

import java.io.Serializable;

/**
 * A reference to a registered Query.
 */
public class Query implements Serializable {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 8643188816731531035L;

    private final String query;

    public Query(final String query) {
        this.query = query;
    }

    @Override
    public String toString() {
        return query;
    }

}
