/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 * --------------------------------------------------------------------------
 * $Id: WAttributeEvent.java 403 2009-01-08 16:26:46Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.event;

import java.util.Map;

import org.ow2.wildcat.hierarchy.Path;

/**
 * WAttributeEvent holds events related to an attribute value change.
 */
public class WAttributeEvent extends WEvent implements WEventInterface {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 8380838667374681500L;

    /**
     * The new value of the attribute.
     */
    protected Object value;

    /**
     * Construct a new global WAttributeEvent.
     *
     * @param source
     *            the location of the attribute
     * @param value
     *            the new value of the attribute
     */
    public WAttributeEvent(final Path source, final Object value) {
        this(source, Scope.GLOBAL, value);
    }

    /**
     * Construct a new WAttributeEvent by setting its scope.
     * @param source the location of the attribute
     * @param scope the scope of the event
     * @param value the new value of the attribute
     */
    public WAttributeEvent(final Path source, final Scope scope, final Object value) {
        super(source, scope);
        this.value = value;
    }

    /**
     * POJO-style getter.
     *
     * @return the attribute new value
     */
    public Object getValue() {
        return this.value;
    }

    /**
     * Map-style getter.
     *
     * @param key
     *            map key
     * @return Map value or <b>null</b> if key is not associated
     */
    @SuppressWarnings("unchecked")
    public Object getValue(final String key) {
        return ((Map<String, Object>) this.value).get(key);
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.wildcat.event.WEvent#toString()
     */
    @Override
    public String toString() {
        return super.toString() + " ---> " + this.value;
    }

}
