/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 * --------------------------------------------------------------------------
 * $Id: WEvent.java 417 2009-05-12 19:14:48Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.event;

import org.ow2.wildcat.hierarchy.Path;

/**
 * Event without arguments.
 */
public class WEvent implements WEventInterface {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = -8737934846415830472L;

    /**
     * The source of the Event.
     */
    protected Path source;

    /**
     * Scope of the event (global by default).
     */
    private Scope scope;


    /**
     * Constructor.
     *
     * @param source
     *            origin of the event
     * @param scope
     *            scope of the event
     */
    public WEvent(final Path source, final Scope scope) {
        this.source = source;
        this.scope = scope;
    }

    /**
     * Construct a new global event.
     *
     * @param source
     *            origin of the event
     */
    public WEvent(final Path source) {
        this.source = source;
        this.scope = Scope.GLOBAL;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.ow2.wildcat.event.WEventInterface#getSource()
     */
    public String getSource() {
        return this.source.toString();
    }

    /**
     * @return the scope of the event
     */
    public Scope getScope() {
        return scope;
    }

    /**
     * Set the scope of the event.
     * @param scope the scope of the event
     */
    public void setScope(final Scope scope) {
        this.scope = scope;
    }


    /**
     * Setter.
     *
     * @param path origin of the event
     */
    public void setSource(final Path path) {
        this.source = path;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String scopeSymbol = "";
        if (scope.equals(Scope.LOCAL)) {
            scopeSymbol = "-";
        } else if (scope.equals(Scope.GLOBAL)) {
            scopeSymbol = "+";
        }
        return "^@(" + scopeSymbol + this.source.toString() + ")";
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#clone()
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

}
