/**
 * WildCAT: A Generic Framework for Context-Aware Applications.
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *		- Pierre-Charles David (initial)
 *		- Nicolas Loriant
 * --------------------------------------------------------------------------
 * $Id: TimeUtil.java 350 2008-11-10 09:41:14Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Date and Time helper class.
 */
public class TimeUtil {

    private static final SimpleDateFormat FORMAT = new SimpleDateFormat(
    "yyyy-MM-dd'T'HH:mm:ssZ");

    /**
     * Format a timestamp into a human readable String.
     *
     * @param timeStamp
     *            a timestamp
     * @return a String representation of the timestamp according to
     *         {@link TimeUtil#FORMAT}
     */
    public static String format(final long timeStamp) {
        return FORMAT.format(new Date(timeStamp));
    }

    /**
     * Compute a timestamp from a human readable String.
     *
     * @param date
     *            a Date and Time in a String representation
     * @return a timestamp
     * @throws ParseException
     *             if <b>date</b> can't be parsed according to
     *             {@link TimeUtil#FORMAT}
     */
    public static long parse(final String date) throws ParseException {
        return FORMAT.parse(date).getTime();
    }

    /**
     * Get current time timestamp.
     *
     * @return current timestamp
     */
    public static long now() {
        return System.currentTimeMillis();
    }
}
