/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.hierarchy.attribute;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.event.WAttributeEvent;
import org.ow2.wildcat.event.WEventInterface;
import org.ow2.wildcat.hierarchy.Mountable;
import org.ow2.wildcat.hierarchy.Path;
import org.ow2.wildcat.hierarchy.attribute.Attribute;
import org.ow2.wildcat.util.Messages;

public class POJOAttribute
implements Attribute {
    private static Log logger = LogFactory.getLog(POJOAttribute.class);
    protected Context context = null;
    protected Path path = null;
    protected Object value;
    private WEventInterface.Scope scope;

    public POJOAttribute(WEventInterface.Scope scope, Object value) {
        this.scope = scope;
        this.value = value;
    }

    public POJOAttribute(Object value) {
        this.scope = WEventInterface.Scope.GLOBAL;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Object setValue(Object value) {
        Object old = this.value;
        this.value = value;
        if (this.isMount()) {
            this.context.emitEvent(new WAttributeEvent(this.path, this.scope, this.value));
        }
        return old;
    }

    public WEventInterface.Scope getScope() {
        return this.scope;
    }

    public void setScope(WEventInterface.Scope scope) {
        this.scope = scope;
    }

    public boolean isMount() {
        return this.context != null && this.path != null;
    }

    public void mount(Context context, Path mountPoint) {
        logger.debug((Object)Messages.message(Mountable.class.getName() + ".mount", mountPoint));
        if (this.isMount()) {
            logger.info((Object)Messages.message(Mountable.class.getName() + ".alreadymount", mountPoint));
        } else {
            this.context = context;
            this.path = mountPoint;
        }
    }

    public void unMount() {
        logger.debug((Object)Messages.message(Mountable.class.getName() + ".unmount", null));
        this.context = null;
        this.path = null;
    }
}

