/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.hierarchy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.hierarchy.MalformedPathException;
import org.ow2.wildcat.util.Messages;
import org.ow2.wildcat.util.PathLexer;
import org.ow2.wildcat.util.PathParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements Serializable {
    private static final long serialVersionUID = 4106680673994638328L;
    private static transient Log logger = LogFactory.getLog(Path.class);
    private boolean absolute;
    private String hostname;
    private final List<String> resources;
    private String attribute;
    public static final Path ROOT = new Path(true, null, new ArrayList<String>(), null);
    public static final Path NULL = new Path(true, "null", new ArrayList<String>(), null);

    private Path(boolean absolute, String hostname, List<String> resources, String attribute) {
        this.absolute = absolute;
        this.hostname = hostname;
        this.resources = resources;
        this.attribute = attribute;
    }

    public Path(String path) throws MalformedPathException {
        logger.debug((Object)Messages.message(Path.class.getName() + ".createString", path));
        PathLexer lexer = new PathLexer((CharStream)new ANTLRStringStream(path));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PathParser parser = new PathParser((TokenStream)tokens);
        PathParser.path_return pr = null;
        try {
            pr = parser.path();
        }
        catch (RecognitionException e) {
            logger.warn((Object)Messages.message(Path.class.getName() + ".createString", path), (Throwable)e);
            throw new MalformedPathException("parsing failled");
        }
        this.absolute = pr.abs;
        this.hostname = pr.h;
        this.resources = pr.r;
        this.attribute = pr.a;
    }

    public Path(Path path) {
        this.hostname = path.hostname;
        this.absolute = path.absolute;
        this.resources = new ArrayList<String>();
        for (int i = 0; i < path.resources.size(); ++i) {
            this.resources.add(path.resources.get(i));
        }
        this.attribute = path.attribute;
    }

    public Path appendResource(String name) {
        try {
            this.expectResource();
            Path n = new Path(this);
            n.resources.add(name);
            return n;
        }
        catch (MalformedPathException e) {
            return null;
        }
    }

    public Path appendAttribute(String name) {
        try {
            this.expectResource();
            Path n = new Path(this);
            n.attribute = name;
            return n;
        }
        catch (MalformedPathException e) {
            return null;
        }
    }

    public Path append(Path suffix) {
        try {
            Path p = new Path(this);
            p.expectResource();
            if (suffix == null) {
                return p;
            }
            suffix.expectRelative();
            p.resources.addAll(suffix.resources);
            p.attribute = suffix.attribute;
            return p;
        }
        catch (MalformedPathException e) {
            return null;
        }
    }

    public Path replacePrefix(Path oprefix, Path nprefix) {
        if (!this.isPrefix(oprefix)) {
            return null;
        }
        Path p = new Path(this);
        p.hostname = null;
        p.absolute = false;
        for (int i = 0; i < oprefix.resources.size(); ++i) {
            p.resources.remove(0);
        }
        return nprefix.append(p);
    }

    public Path getParentPath() {
        if (this.isOnlyAttribute() || this.isOnlyResource()) {
            throw new IllegalArgumentException("Unable to retrieve a parent path with only a resource name or an attribute name!");
        }
        Path superPath = new Path(this);
        if (this.attribute == null) {
            superPath.resources.remove(superPath.resources.size() - 1);
        } else {
            superPath.attribute = null;
        }
        return superPath;
    }

    public Path canonicalize() {
        boolean abs = this.isAbsolute();
        String h = this.hostname;
        ArrayList<String> r = new ArrayList<String>();
        String a = this.attribute;
        for (String s : this.resources) {
            if (".".equals(s)) continue;
            if ("..".equals(s)) {
                if (r.size() > 0) {
                    if ("..".equals(r.get(r.size() - 1))) {
                        r.add("..");
                        continue;
                    }
                    r.remove(r.size() - 1);
                    continue;
                }
                if (abs) continue;
                r.add("..");
                continue;
            }
            r.add(s);
        }
        return new Path(abs, h, r, a);
    }

    public Path stripTop() {
        try {
            Path p = new Path(this);
            if (p.isAbsolute()) {
                p.absolute = false;
                p.hostname = null;
            } else {
                p.resources.remove(0);
            }
            return p;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Path getRelativePart() {
        if (!this.hasAttribute() && !this.hasResource()) {
            return null;
        }
        Path p = new Path(this);
        p.hostname = null;
        p.absolute = false;
        return p;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostName(String hostname) {
        this.hostname = hostname;
    }

    public String getAttributeName() {
        return this.attribute;
    }

    public String getFirstResource() {
        return this.resources.get(0);
    }

    public boolean isAbsolute() {
        return this.absolute || this.hasExplicitHost();
    }

    public boolean hasExplicitHost() {
        return this.hostname != null;
    }

    public boolean hasAttribute() {
        return this.attribute != null;
    }

    public boolean hasResource() {
        return this.resources != null && this.resources.size() != 0;
    }

    public boolean isOnlyAttribute() {
        return !this.isAbsolute() && (this.resources == null || this.resources.size() == 0) && this.hasAttribute();
    }

    public boolean isOnlyResource() {
        return !this.isAbsolute() && !this.hasAttribute() && this.resources.size() == 1;
    }

    public boolean isCanonical() {
        if (this.resources != null) {
            for (String s : this.resources) {
                if (!".".equals(s) && !"..".equals(s)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isPattern() {
        if (this.resources != null) {
            for (String s : this.resources) {
                if (!"*".equals(s)) continue;
                return true;
            }
        }
        return "*".equals(this.attribute);
    }

    public boolean isPrefix(Path prefix) {
        try {
            prefix.expectAbsolute();
            prefix.expectResource();
            prefix.expectCanonical();
            prefix.expectFinite();
            if (this.resources.size() < prefix.resources.size()) {
                return false;
            }
            for (int i = 0; i < prefix.resources.size(); ++i) {
                if (prefix.resources.get(i).equals(this.resources.get(i))) continue;
                return false;
            }
            return this.hostname.equals(prefix.hostname);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidHostname(String hostname) {
        return Path.isValidID(hostname);
    }

    public static boolean isValidResourceName(String resourceName) {
        return Path.isValidID(resourceName);
    }

    public static boolean isValidAttributeName(String attributeName) {
        return Path.isValidID(attributeName);
    }

    private static boolean isValidID(String atom) {
        return Pattern.matches("[_a-zA-Z][a-zA-Z_0-9]*", atom);
    }

    public void expectCanonical() throws MalformedPathException {
        if (!this.isCanonical()) {
            throw new MalformedPathException("Canonical path expected got '" + this.toString() + "'");
        }
    }

    public void expectFinite() throws MalformedPathException {
        if (this.isPattern()) {
            throw new MalformedPathException("Finite path expected got '" + this.toString() + "'");
        }
    }

    public void expectAbsolute() throws MalformedPathException {
        if (!this.isAbsolute()) {
            throw new MalformedPathException("Absolute path expected got '" + this.toString() + "'");
        }
    }

    public void expectRelative() throws MalformedPathException {
        if (this.isAbsolute()) {
            throw new MalformedPathException("Relative path expected got '" + this.toString() + "'");
        }
    }

    public void expectResource() throws MalformedPathException {
        if (this.hasAttribute()) {
            throw new MalformedPathException("Resource path expected got '" + this.toString() + "'");
        }
    }

    public void expectAttribute() throws MalformedPathException {
        if (!this.hasAttribute()) {
            throw new MalformedPathException("Attribute path expected got '" + this.toString() + "'");
        }
    }

    public String toString() {
        String c = "";
        boolean first = true;
        if (this.hostname != null) {
            c = c + this.hostname + "://";
        } else if (this.absolute) {
            c = c + "self://";
        }
        for (String r : this.resources) {
            if (first) {
                c = c + r;
                first = false;
                continue;
            }
            c = c + "/" + r;
        }
        if (this.hasAttribute()) {
            c = c + "#" + this.attribute;
        }
        return c;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Path)) {
            return false;
        }
        Path path = (Path)object;
        if (this.absolute != path.absolute || this.absolute && !this.hostname.equals(path.hostname)) {
            return false;
        }
        return (this.resources == null && path.resources == null || this.resources != null && ((Object)this.resources).equals(path.resources)) && (this.attribute == null && path.attribute == null || this.attribute != null && this.attribute.equals(path.attribute));
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Boolean.valueOf(this.absolute).hashCode();
        hash = 31 * hash + (this.absolute && this.hostname != null ? this.hostname.hashCode() : 0);
        hash = 31 * hash + (this.resources != null ? ((Object)this.resources).hashCode() : 0);
        hash = 31 * hash + (this.attribute != null ? this.attribute.hashCode() : 0);
        return hash;
    }
}

