/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.scheduler.event;

import java.io.Serializable;

public class DiaryPeriod
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int unit = 14;
    public int value = 0;

    public DiaryPeriod() {
    }

    public DiaryPeriod(int unit, int value) {
        switch (unit) {
            case 1: 
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown diary period unit");
            }
        }
        this.unit = unit;
        this.value = value;
    }

    public DiaryPeriod(long value) {
        long MS_SECOND = 1000L;
        long MS_MINUTE = 60000L;
        long MS_HOUR = 3600000L;
        long MS_DAY = 86400000L;
        long MS_MONTH = 2592000000L;
        long MS_YEAR = 31536000000L;
        if (value != 0L) {
            if (value % 31536000000L == 0L) {
                this.unit = 1;
                this.value = (int)(value / 31536000000L);
            } else if (value % 2592000000L == 0L) {
                this.unit = 2;
                this.value = (int)(value / 2592000000L);
            } else if (value % 86400000L == 0L) {
                this.unit = 5;
                this.value = (int)(value / 86400000L);
            } else if (value % 3600000L == 0L) {
                this.unit = 11;
                this.value = (int)(value / 3600000L);
            } else if (value % 60000L == 0L) {
                this.unit = 12;
                this.value = (int)(value / 60000L);
            } else if (value % 1000L == 0L) {
                this.unit = 13;
                this.value = (int)(value / 1000L);
            } else {
                this.unit = 14;
                this.value = (int)value;
            }
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("(");
        output.append(super.toString());
        output.append(",unit=");
        output.append(this.unit);
        output.append(",value=");
        output.append(this.value);
        output.append(")");
        return output.toString();
    }
}

