/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.agent.ServiceManager;
import fr.dyade.aaa.agent.conf.A3CML;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.util.Daemon;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class AdminProxy {
    static AdminProxy proxy = null;
    public static boolean debug = true;
    public static final String LISTENPORT = "fr.dyade.aaa.agent.AdminProxy.port";
    private static int port = 8091;
    private static int nbm;
    public static final String NBMONITOR = "fr.dyade.aaa.agent.AdminProxy.nbm";
    AdminMonitor[] monitors = null;
    ServerSocket listen = null;
    static Logger xlogmon;
    static final String HELP = "help";
    static final String NONE = "";
    public static final String STOP_SERVER = "halt";
    public static final String CRASH_SERVER = "crash";
    public static final String PING = "ping";
    public static final String CONFIG = "config";
    static final String SET_VARIABLE = "set";
    static final String GET_VARIABLE = "get";
    static final String GC = "gc";
    static final String THREADS = "threads";
    static final String LIST_MCONS = "consumers";
    static final String START_MCONS = "start";
    static final String STOP_MCONS = "stop";
    static final String LIST_SERVICE = "services";
    static final String ADD_SERVICE = "add";
    static final String REMOVE_SERVICE = "remove";
    static final String DUMP = "dump";
    public static final String LOG = "log";

    public static void init(String args, boolean firstTime) throws Exception {
        try {
            port = args.length() != 0 ? Integer.parseInt(args) : Integer.parseInt(AgentServer.getProperty(LISTENPORT, "8091"));
        }
        catch (NumberFormatException exc) {
            port = 8091;
        }
        try {
            nbm = Integer.parseInt(AgentServer.getProperty(NBMONITOR, "1"));
        }
        catch (NumberFormatException exc) {
            nbm = 1;
        }
        xlogmon = Debug.getLogger("fr.dyade.aaa.agent.Service.AdminProxy.#" + AgentServer.getServerId());
        if (proxy != null) {
            xlogmon.log(BasicLevel.ERROR, (Object)("AdminProxy#" + AgentServer.getServerId() + ": already initialized."));
            throw new Exception("AdminProxy.#" + AgentServer.getServerId() + ": already initialized.");
        }
        try {
            proxy = new AdminProxy();
        }
        catch (IOException exc) {
            xlogmon.log(BasicLevel.ERROR, (Object)("AdminProxy#" + AgentServer.getServerId() + ", can't get listen port"), (Throwable)exc);
            throw exc;
        }
        AdminProxy.start();
    }

    private AdminProxy() throws IOException {
        int i = 0;
        while (true) {
            try {
                this.listen = new ServerSocket(port);
            }
            catch (BindException exc) {
                if (i > 5) {
                    throw exc;
                }
                try {
                    Thread.sleep(i * 500);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            break;
        }
        this.monitors = new AdminMonitor[nbm];
        for (i = 0; i < this.monitors.length; ++i) {
            this.monitors[i] = new AdminMonitor("AdminProxy#" + AgentServer.getServerId() + '.' + i);
        }
    }

    public static void start() {
        for (int i = 0; i < AdminProxy.proxy.monitors.length; ++i) {
            AdminProxy.proxy.monitors[i].start();
        }
    }

    public static void stopService() {
        for (int i = 0; i < AdminProxy.proxy.monitors.length; ++i) {
            if (AdminProxy.proxy.monitors[i] != null) {
                AdminProxy.proxy.monitors[i].stop();
            }
            AdminProxy.proxy.monitors[i] = null;
        }
        proxy = null;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("(").append(super.toString());
        strBuf.append(",port=").append(port);
        strBuf.append(",monitors=[");
        for (int i = 0; i < this.monitors.length; ++i) {
            strBuf.append(this.monitors[i].toString()).append(",");
        }
        strBuf.append("]");
        strBuf.append(")");
        return strBuf.toString();
    }

    static {
        xlogmon = null;
    }

    class AdminMonitor
    extends Daemon {
        Socket socket;
        BufferedReader reader;
        PrintWriter writer;

        protected AdminMonitor(String name) {
            super(name, xlogmon);
            this.socket = null;
            this.reader = null;
            this.writer = null;
            this.setThreadGroup(AgentServer.getThreadGroup());
        }

        public String toString() {
            return "(" + super.toString() + ",socket=" + this.socket + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (this.running) {
                    block30: {
                        block29: {
                            block28: {
                                block21: {
                                    this.canStop = true;
                                    try {
                                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting: " + AdminProxy.this.listen));
                                        this.socket = AdminProxy.this.listen.accept();
                                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", receiving."));
                                        this.canStop = false;
                                    }
                                    catch (IOException exc) {
                                        if (!this.running) break block21;
                                        this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during accept"), (Throwable)exc);
                                    }
                                }
                                if (!this.running) break;
                                try {
                                    try {
                                        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                                        this.writer = new PrintWriter(this.socket.getOutputStream(), true);
                                        this.doRequest(this.reader.readLine());
                                        this.writer.flush();
                                    }
                                    catch (Exception exc) {
                                        this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during connection"), (Throwable)exc);
                                        var3_4 = null;
                                        try {
                                            this.reader.close();
                                        }
                                        catch (Exception exc) {
                                            // empty catch block
                                        }
                                        this.reader = null;
                                        try {
                                            this.writer.close();
                                        }
                                        catch (Exception exc) {
                                            // empty catch block
                                        }
                                        this.writer = null;
                                        try {
                                            this.socket.close();
                                        }
                                        catch (Exception exc) {
                                            // empty catch block
                                        }
                                        this.socket = null;
                                        continue;
                                    }
                                    var3_4 = null;
                                }
                                catch (Throwable var2_6) {
                                    block27: {
                                        block26: {
                                            block25: {
                                                var3_4 = null;
                                                ** try [egrp 4[TRYBLOCK] [5 : 282->292)] { 
lbl54:
                                                // 1 sources

                                                this.reader.close();
                                                break block25;
lbl56:
                                                // 1 sources

                                                catch (Exception exc) {
                                                    // empty catch block
                                                }
                                            }
                                            this.reader = null;
                                            ** try [egrp 5[TRYBLOCK] [6 : 299->309)] { 
lbl61:
                                            // 1 sources

                                            this.writer.close();
                                            break block26;
lbl63:
                                            // 1 sources

                                            catch (Exception exc) {
                                                // empty catch block
                                            }
                                        }
                                        this.writer = null;
                                        ** try [egrp 6[TRYBLOCK] [7 : 316->326)] { 
lbl68:
                                        // 1 sources

                                        this.socket.close();
                                        break block27;
lbl70:
                                        // 1 sources

                                        catch (Exception exc) {
                                            // empty catch block
                                        }
                                    }
                                    this.socket = null;
                                    throw var2_6;
                                }
                                ** try [egrp 4[TRYBLOCK] [5 : 282->292)] { 
lbl76:
                                // 1 sources

                                this.reader.close();
                                break block28;
lbl78:
                                // 1 sources

                                catch (Exception exc) {
                                    // empty catch block
                                }
                            }
                            this.reader = null;
                            ** try [egrp 5[TRYBLOCK] [6 : 299->309)] { 
lbl83:
                            // 1 sources

                            this.writer.close();
                            break block29;
lbl85:
                            // 1 sources

                            catch (Exception exc) {
                                // empty catch block
                            }
                        }
                        this.writer = null;
                        ** try [egrp 6[TRYBLOCK] [7 : 316->326)] { 
lbl90:
                        // 1 sources

                        this.socket.close();
                        break block30;
lbl92:
                        // 1 sources

                        catch (Exception exc) {
                            // empty catch block
                        }
                    }
                    this.socket = null;
                }
                var6_7 = null;
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", finishing."));
            }
            catch (Throwable var5_9) {
                var6_8 = null;
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", finishing."));
                this.finish();
                throw var5_9;
            }
            this.finish();
        }

        protected void close() {
            try {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", closing: " + AdminProxy.this.listen));
                AdminProxy.this.listen.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AdminProxy.this.listen = null;
        }

        protected void shutdown() {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", close(): "));
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doRequest(String request) {
            int i;
            ServiceDesc[] services;
            block80: {
                Enumeration c;
                String domain;
                block79: {
                    int j;
                    Thread[] tab;
                    int nbt;
                    String group;
                    block78: {
                        String cmd = null;
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", request=" + request));
                        try {
                            StringTokenizer st = new StringTokenizer(request);
                            cmd = st.nextToken();
                            if (cmd.equals(AdminProxy.STOP_SERVER)) {
                                AgentServer.stop(false);
                                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", bye."));
                                return;
                            }
                            if (cmd.equals(AdminProxy.CRASH_SERVER)) {
                                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", crash!"));
                                System.exit(0);
                                return;
                            }
                            if (cmd.equals(AdminProxy.GC)) {
                                Runtime runtime = Runtime.getRuntime();
                                this.writer.println("before: " + runtime.freeMemory() + " octets free / " + runtime.totalMemory() + " octets.");
                                runtime.gc();
                                this.writer.println("after: " + runtime.freeMemory() + " octets free / " + runtime.totalMemory() + " octets.");
                                return;
                            }
                            if (cmd.equals(AdminProxy.SET_VARIABLE)) {
                                try {
                                    block77: {
                                        if (st.countTokens() != 2) {
                                            throw new Exception("Usage: set property value");
                                        }
                                        String property = st.nextToken();
                                        String value = st.nextToken();
                                        int pindex = property.lastIndexOf(46);
                                        if (pindex == -1) {
                                            throw new Exception("bad formed property name: " + property);
                                        }
                                        String varClassName = property.substring(0, pindex);
                                        String varName = property.substring(pindex + 1);
                                        try {
                                            Class<?> varClass = Class.forName(varClassName);
                                            Field var = varClass.getDeclaredField(varName);
                                            String varType = var.getType().getName();
                                            if (varType.equals("boolean") || varType.equals("java.lang.Boolean")) {
                                                var.set(null, new Boolean(value));
                                                break block77;
                                            }
                                            if (varType.equals("int") || varType.equals("java.lang.Integer")) {
                                                var.set(null, new Integer(value));
                                            } else {
                                                if (!varType.equals("java.lang.String")) throw new Exception("error setting property " + varClassName + "." + varName + ": unexpected type " + varType);
                                                var.set(null, value);
                                            }
                                        }
                                        catch (Exception exc) {
                                            if (!debug) throw new Exception("error setting property " + varClassName + "." + varName + ": " + exc.getMessage());
                                            exc.printStackTrace(this.writer);
                                            throw new Exception("error setting property " + varClassName + "." + varName + ": " + exc.getMessage());
                                        }
                                    }
                                    this.writer.println("done.");
                                    return;
                                }
                                catch (Exception exc) {
                                    this.writer.println(exc.getMessage());
                                }
                                return;
                            }
                            if (cmd.equals(AdminProxy.GET_VARIABLE)) {
                                try {
                                    if (st.countTokens() != 1) {
                                        throw new Exception("Usage: get property");
                                    }
                                    String property = st.nextToken();
                                    int pindex = property.lastIndexOf(46);
                                    if (pindex == -1) {
                                        throw new Exception("bad formed property name: " + property);
                                    }
                                    String varClassName = property.substring(0, pindex);
                                    String varName = property.substring(pindex + 1);
                                    try {
                                        Class<?> varClass = Class.forName(varClassName);
                                        Field var = varClass.getDeclaredField(varName);
                                        Object value = var.get(null);
                                        this.writer.println(property + " = " + value);
                                        return;
                                    }
                                    catch (Exception exc) {
                                        if (!debug) throw new Exception("error getting property " + varClassName + "." + varName + ": " + exc.getMessage());
                                        exc.printStackTrace(this.writer);
                                        throw new Exception("error getting property " + varClassName + "." + varName + ": " + exc.getMessage());
                                    }
                                }
                                catch (Exception exc) {
                                    this.writer.println(exc.getMessage());
                                }
                                return;
                            }
                            if (cmd.equals(AdminProxy.THREADS)) {
                                group = null;
                                if (st.hasMoreTokens()) {
                                    group = st.nextToken();
                                }
                                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                                while (tg.getParent() != null) {
                                    tg = tg.getParent();
                                }
                                nbt = tg.activeCount();
                                tab = new Thread[nbt];
                                tg.enumerate(tab);
                                j = 0;
                                break block78;
                            }
                            if (cmd.equals(AdminProxy.LIST_MCONS)) {
                                Enumeration c2 = AgentServer.getConsumers();
                                while (c2.hasMoreElements()) {
                                    MessageConsumer cons = (MessageConsumer)c2.nextElement();
                                    this.writer.println("+----------------------------------------");
                                    this.writer.println(cons);
                                }
                                return;
                            }
                            if (cmd.equals(AdminProxy.START_MCONS)) {
                                domain = null;
                                if (st.hasMoreTokens()) {
                                    domain = st.nextToken();
                                }
                                c = AgentServer.getConsumers();
                                break block79;
                            }
                            if (cmd.equals(AdminProxy.STOP_MCONS)) {
                                String domain2 = null;
                                if (st.hasMoreTokens()) {
                                    domain2 = st.nextToken();
                                }
                                Enumeration c3 = AgentServer.getConsumers();
                                while (c3.hasMoreElements()) {
                                    MessageConsumer cons = (MessageConsumer)c3.nextElement();
                                    if (domain2 != null && !domain2.equals(cons.getName())) continue;
                                    cons.stop();
                                    this.writer.println("stop " + cons.getName() + " done.");
                                }
                                return;
                            }
                            if (cmd.equals(AdminProxy.LIST_SERVICE)) {
                                services = ServiceManager.getServices();
                                i = 0;
                                break block80;
                            }
                            if (cmd.equals(AdminProxy.ADD_SERVICE)) {
                                try {
                                    String sclass = null;
                                    String args = null;
                                    try {
                                        sclass = st.nextToken();
                                        if (st.hasMoreTokens()) {
                                            args = st.nextToken();
                                        }
                                    }
                                    catch (NoSuchElementException exc) {
                                        throw new Exception("Usage: add <sclass> [<args>]");
                                    }
                                    try {
                                        ServiceManager.register(sclass, args);
                                        this.writer.println("Service <" + sclass + "> registred.");
                                        ServiceManager.start(sclass);
                                        this.writer.println("Service <" + sclass + "> started.");
                                        return;
                                    }
                                    catch (Exception exc) {
                                        this.writer.println("Can't start service: " + exc.getMessage());
                                        if (!debug) return;
                                        exc.printStackTrace(this.writer);
                                    }
                                    return;
                                }
                                catch (Exception exc) {
                                    this.writer.println(exc.getMessage());
                                }
                                return;
                            }
                            if (cmd.equals(AdminProxy.REMOVE_SERVICE)) {
                                String sclass;
                                block81: {
                                    sclass = null;
                                    try {
                                        sclass = st.nextToken();
                                    }
                                    catch (NoSuchElementException exc) {
                                        this.writer.println("Usage: remove <sclass> [<args>]");
                                        return;
                                    }
                                    try {
                                        ServiceManager.stop(sclass);
                                        this.writer.println("Service <" + sclass + "> stopped.");
                                    }
                                    catch (Exception exc) {
                                        this.writer.println("Can't stop service: " + exc.getMessage());
                                        if (!debug) break block81;
                                        exc.printStackTrace(this.writer);
                                    }
                                }
                                try {
                                    ServiceManager.unregister(sclass);
                                    this.writer.println("Service <" + sclass + "> unregistred.");
                                    return;
                                }
                                catch (Exception exc) {
                                    this.writer.println("Can't unregister service: " + exc.getMessage());
                                    if (!debug) return;
                                    exc.printStackTrace(this.writer);
                                }
                                return;
                            }
                            if (cmd.equals(AdminProxy.DUMP)) {
                                AgentId id = null;
                                try {
                                    id = AgentId.fromString(st.nextToken());
                                }
                                catch (IllegalArgumentException exc) {
                                    this.writer.println("Usage: dump #x.y.z");
                                    return;
                                }
                                try {
                                    this.writer.println(AgentServer.getEngine().dumpAgent(id));
                                    return;
                                }
                                catch (Exception exc) {
                                    this.writer.println("Can't launch server: " + exc.getMessage());
                                    if (!debug) return;
                                    exc.printStackTrace(this.writer);
                                }
                                return;
                            }
                            if (cmd.equals(AdminProxy.NONE)) return;
                            if (cmd.equals(AdminProxy.PING)) {
                                this.writer.println(AgentServer.getServerId());
                                return;
                            }
                            if (cmd.equals(AdminProxy.CONFIG)) {
                                try {
                                    A3CMLConfig a3CMLConfig = AgentServer.getConfig();
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    PrintWriter out = new PrintWriter(baos);
                                    A3CML.toXML(a3CMLConfig, out);
                                    out.flush();
                                    baos.flush();
                                    baos.close();
                                    byte[] bytes = baos.toByteArray();
                                    this.writer.println(new String(bytes));
                                    return;
                                }
                                catch (Exception exc) {
                                    this.writer.println("Can't load configuration: " + exc.getMessage());
                                    if (!debug) return;
                                    exc.printStackTrace(this.writer);
                                }
                                return;
                            }
                            if (cmd.equals(AdminProxy.LOG)) {
                                int intLevel;
                                String topic;
                                PrintStream oldErr;
                                block82: {
                                    oldErr = System.err;
                                    System.setErr(new PrintStream(this.socket.getOutputStream()));
                                    topic = st.nextToken();
                                    String level = st.nextToken();
                                    if (level.equals("DEBUG")) {
                                        intLevel = BasicLevel.DEBUG;
                                        break block82;
                                    }
                                    if (level.equals("ERROR")) {
                                        intLevel = BasicLevel.ERROR;
                                        break block82;
                                    }
                                    if (level.equals("FATAL")) {
                                        intLevel = BasicLevel.FATAL;
                                        break block82;
                                    }
                                    if (level.equals("INFO")) {
                                        intLevel = BasicLevel.INFO;
                                        break block82;
                                    }
                                    if (level.equals("INHERIT")) {
                                        intLevel = BasicLevel.INHERIT;
                                        break block82;
                                    }
                                    if (level.equals("WARN")) {
                                        intLevel = BasicLevel.WARN;
                                        break block82;
                                    }
                                    this.writer.println("Unknown level: " + level);
                                    Object var13_67 = null;
                                    System.setErr(oldErr);
                                    this.writer.println("OK");
                                    return;
                                }
                                try {
                                    try {
                                        Debug.setLoggerLevel(topic, intLevel);
                                    }
                                    catch (Exception exc) {
                                        this.writer.println(exc.getMessage());
                                        Object var13_69 = null;
                                        System.setErr(oldErr);
                                        this.writer.println("OK");
                                        return;
                                    }
                                    Object var13_68 = null;
                                    System.setErr(oldErr);
                                    this.writer.println("OK");
                                    return;
                                }
                                catch (Throwable throwable) {
                                    Object var13_70 = null;
                                    System.setErr(oldErr);
                                    this.writer.println("OK");
                                    throw throwable;
                                }
                            }
                            if (cmd.equals(AdminProxy.HELP)) {
                                this.writer.println("Description of available commands:\n\thelp\n\t\tGives the summary of the options.\n\thalt\n\t\tStops the server.\n\tsetvariable value\n\t\tSet the specified static variable with the given value.\n\tget\n\t\tReturn the value of the specified static variable.\n\tgc\n\t\tRun the garbage collector in the specified A3 server.\n\tthreads [group]\n\t\tList all threads in server JVM.\n\tconsumers\n\t\tList all defined consumers.\n\tstart [domain]\n\t\tStarts the specified MessageConsumer.\n\tstop [domain]\n\t\tStops the specified MessageConsumer.\n\tservices\n\t\tList all registered services.\n\tadd classname arguments\n\t\tRegisters and starts the specified Service.\n\tremove classname\n\t\tStops then unregister the specified Service.\n\tconfig\n\t\tReturns the configuration of the server in XML format.\n");
                                return;
                            } else {
                                this.writer.println("unknown command:" + cmd);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var15_66 = null;
                            throw throwable;
                        }
                    }
                    while (j < nbt) {
                        if (group == null || tab[j].getThreadGroup().getName().equals(group)) {
                            this.writer.println("+----------------------------------------");
                            this.writer.println("[" + (group == null ? tab[j].getThreadGroup().getName() + "." : AdminProxy.NONE) + tab[j].getName() + "]" + (tab[j].isAlive() ? " alive" : AdminProxy.NONE) + (tab[j].isDaemon() ? " daemon" : AdminProxy.NONE) + "\n " + tab[j]);
                        }
                        ++j;
                    }
                    return;
                }
                while (c.hasMoreElements()) {
                    MessageConsumer cons = (MessageConsumer)c.nextElement();
                    if (domain != null && !domain.equals(cons.getName())) continue;
                    try {
                        cons.start();
                        this.writer.println("start " + cons.getName() + " done.");
                    }
                    catch (Exception exc) {
                        this.writer.println("Can't start " + cons.getName() + ": " + exc.getMessage());
                        if (!debug) continue;
                        exc.printStackTrace(this.writer);
                    }
                }
                return;
            }
            while (i < services.length) {
                this.writer.println("+----------------------------------------");
                this.writer.println(services[i].getClassName() + " (" + services[i].getArguments() + ")" + (services[i].isInitialized() ? " initialized " : AdminProxy.NONE) + (services[i].isRunning() ? " running" : AdminProxy.NONE));
                ++i;
            }
        }
    }
}

