/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.esper.client.ConfigurationAdapterLoader;
import net.esper.client.ConfigurationDBRef;
import net.esper.client.ConfigurationEngineDefaults;
import net.esper.client.ConfigurationEventTypeLegacy;
import net.esper.client.ConfigurationEventTypeXMLDOM;
import net.esper.client.ConfigurationInformation;
import net.esper.client.ConfigurationMethodRef;
import net.esper.client.ConfigurationOperations;
import net.esper.client.ConfigurationParser;
import net.esper.client.ConfigurationPlugInAggregationFunction;
import net.esper.client.ConfigurationPlugInPatternObject;
import net.esper.client.ConfigurationPlugInView;
import net.esper.client.ConfigurationVariable;
import net.esper.client.EPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements ConfigurationOperations,
ConfigurationInformation,
Serializable {
    private static Log log = LogFactory.getLog(Configuration.class);
    protected static final String ESPER_DEFAULT_CONFIG = "esper.cfg.xml";
    protected Map<String, String> eventClasses;
    protected Map<String, ConfigurationEventTypeXMLDOM> eventTypesXMLDOM;
    protected Map<String, ConfigurationEventTypeLegacy> eventTypesLegacy;
    protected Map<String, Properties> mapAliases;
    protected List<String> imports;
    protected Map<String, ConfigurationDBRef> databaseReferences;
    private boolean isUsingDefaultImports = true;
    protected String epServicesContextFactoryClassName;
    protected List<ConfigurationPlugInView> plugInViews;
    protected List<ConfigurationPlugInPatternObject> plugInPatternObjects;
    protected List<ConfigurationPlugInAggregationFunction> plugInAggregationFunctions;
    protected List<ConfigurationAdapterLoader> adapterLoaders;
    protected ConfigurationEngineDefaults engineDefaults;
    protected Set<String> eventTypeAutoAliasPackages;
    protected Map<String, ConfigurationVariable> variables;
    protected Map<String, ConfigurationMethodRef> methodInvocationReferences;

    public Configuration() {
        this.reset();
    }

    public void setEPServicesContextFactoryClassName(String epServicesContextFactoryClassName) {
        this.epServicesContextFactoryClassName = epServicesContextFactoryClassName;
    }

    @Override
    public String getEPServicesContextFactoryClassName() {
        return this.epServicesContextFactoryClassName;
    }

    @Override
    public void addPlugInAggregationFunction(String functionName, String aggregationClassName) {
        ConfigurationPlugInAggregationFunction entry = new ConfigurationPlugInAggregationFunction();
        entry.setFunctionClassName(aggregationClassName);
        entry.setName(functionName);
        this.plugInAggregationFunctions.add(entry);
    }

    @Override
    public void addEventTypeAlias(String eventTypeAlias, String javaEventClassName) {
        this.eventClasses.put(eventTypeAlias, javaEventClassName);
    }

    @Override
    public void addEventTypeAlias(String eventTypeAlias, Class javaEventClass) {
        this.addEventTypeAlias(eventTypeAlias, javaEventClass.getName());
    }

    @Override
    public void addEventTypeAliasSimpleName(Class javaEventClass) {
        this.addEventTypeAlias(javaEventClass.getSimpleName(), javaEventClass.getName());
    }

    @Override
    public void addEventTypeAlias(String eventTypeAlias, Properties typeMap) {
        this.mapAliases.put(eventTypeAlias, typeMap);
    }

    @Override
    public void addEventTypeAlias(String eventTypeAlias, Map<String, Class> typeMap) {
        Properties properties = new Properties();
        for (Map.Entry<String, Class> entry : typeMap.entrySet()) {
            properties.put(entry.getKey(), entry.getValue().getName());
        }
        this.addEventTypeAlias(eventTypeAlias, properties);
    }

    @Override
    public void addEventTypeAlias(String eventTypeAlias, ConfigurationEventTypeXMLDOM xmlDOMEventTypeDesc) {
        this.eventTypesXMLDOM.put(eventTypeAlias, xmlDOMEventTypeDesc);
    }

    public void addDatabaseReference(String name, ConfigurationDBRef configurationDBRef) {
        this.databaseReferences.put(name, configurationDBRef);
    }

    public void addEventTypeAlias(String eventTypeAlias, String javaEventClass, ConfigurationEventTypeLegacy legacyEventTypeDesc) {
        this.eventClasses.put(eventTypeAlias, javaEventClass);
        this.eventTypesLegacy.put(eventTypeAlias, legacyEventTypeDesc);
    }

    @Override
    public void addImport(String autoImport) {
        if (this.isUsingDefaultImports) {
            this.isUsingDefaultImports = false;
            this.imports.clear();
        }
        this.imports.add(autoImport);
    }

    public void addMethodRef(String className, ConfigurationMethodRef methodInvocationConfig) {
        this.methodInvocationReferences.put(className, methodInvocationConfig);
    }

    public void addMethodRef(Class clazz, ConfigurationMethodRef methodInvocationConfig) {
        this.methodInvocationReferences.put(clazz.getName(), methodInvocationConfig);
    }

    @Override
    public Map<String, String> getEventTypeAliases() {
        return this.eventClasses;
    }

    @Override
    public Map<String, Properties> getEventTypesMapEvents() {
        return this.mapAliases;
    }

    @Override
    public Map<String, ConfigurationEventTypeXMLDOM> getEventTypesXMLDOM() {
        return this.eventTypesXMLDOM;
    }

    @Override
    public Map<String, ConfigurationEventTypeLegacy> getEventTypesLegacy() {
        return this.eventTypesLegacy;
    }

    @Override
    public List<String> getImports() {
        return this.imports;
    }

    @Override
    public Map<String, ConfigurationDBRef> getDatabaseReferences() {
        return this.databaseReferences;
    }

    @Override
    public List<ConfigurationPlugInView> getPlugInViews() {
        return this.plugInViews;
    }

    @Override
    public List<ConfigurationAdapterLoader> getAdapterLoaders() {
        return this.adapterLoaders;
    }

    @Override
    public List<ConfigurationPlugInAggregationFunction> getPlugInAggregationFunctions() {
        return this.plugInAggregationFunctions;
    }

    @Override
    public List<ConfigurationPlugInPatternObject> getPlugInPatternObjects() {
        return this.plugInPatternObjects;
    }

    @Override
    public Map<String, ConfigurationVariable> getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, ConfigurationMethodRef> getMethodInvocationReferences() {
        return this.methodInvocationReferences;
    }

    public void addAdapterLoader(String loaderName, String className, Properties configuration) {
        ConfigurationAdapterLoader adapterLoader = new ConfigurationAdapterLoader();
        adapterLoader.setLoaderName(loaderName);
        adapterLoader.setClassName(className);
        adapterLoader.setConfigProperties(configuration);
        this.adapterLoaders.add(adapterLoader);
    }

    public void addPlugInView(String namespace, String name, String viewFactoryClass) {
        ConfigurationPlugInView configurationPlugInView = new ConfigurationPlugInView();
        configurationPlugInView.setNamespace(namespace);
        configurationPlugInView.setName(name);
        configurationPlugInView.setFactoryClassName(viewFactoryClass);
        this.plugInViews.add(configurationPlugInView);
    }

    public void addPlugInPatternObserver(String namespace, String name, String observerFactoryClass) {
        ConfigurationPlugInPatternObject entry = new ConfigurationPlugInPatternObject();
        entry.setNamespace(namespace);
        entry.setName(name);
        entry.setFactoryClassName(observerFactoryClass);
        entry.setPatternObjectType(ConfigurationPlugInPatternObject.PatternObjectType.OBSERVER);
        this.plugInPatternObjects.add(entry);
    }

    public void addPlugInPatternGuard(String namespace, String name, String guardFactoryClass) {
        ConfigurationPlugInPatternObject entry = new ConfigurationPlugInPatternObject();
        entry.setNamespace(namespace);
        entry.setName(name);
        entry.setFactoryClassName(guardFactoryClass);
        entry.setPatternObjectType(ConfigurationPlugInPatternObject.PatternObjectType.GUARD);
        this.plugInPatternObjects.add(entry);
    }

    @Override
    public void addEventTypeAutoAlias(String javaPackageName) {
        this.eventTypeAutoAliasPackages.add(javaPackageName);
    }

    @Override
    public void addVariable(String variableName, Class type, Object initializationValue) {
        ConfigurationVariable configVar = new ConfigurationVariable();
        configVar.setType(type);
        configVar.setInitializationValue(initializationValue);
        this.variables.put(variableName, configVar);
    }

    public Set<String> getEventTypeAutoAliasPackages() {
        return this.eventTypeAutoAliasPackages;
    }

    @Override
    public ConfigurationEngineDefaults getEngineDefaults() {
        return this.engineDefaults;
    }

    public Configuration configure() throws EPException {
        this.configure("/esper.cfg.xml");
        return this;
    }

    public Configuration configure(String resource) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("configuring from resource: " + resource);
        }
        InputStream stream = Configuration.getConfigurationInputStream(resource);
        ConfigurationParser.doConfigure(this, stream, resource);
        return this;
    }

    protected static InputStream getConfigurationInputStream(String resource) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("Configuration resource: " + resource);
        }
        return Configuration.getResourceAsStream(resource);
    }

    public Configuration configure(URL url) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("configuring from url: " + url.toString());
        }
        try {
            ConfigurationParser.doConfigure(this, url.openStream(), url.toString());
            return this;
        }
        catch (IOException ioe) {
            throw new EPException("could not configure from URL: " + url, ioe);
        }
    }

    public Configuration configure(File configFile) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("configuring from file: " + configFile.getName());
        }
        try {
            ConfigurationParser.doConfigure(this, new FileInputStream(configFile), configFile.toString());
        }
        catch (FileNotFoundException fnfe) {
            throw new EPException("could not find file: " + configFile, fnfe);
        }
        return this;
    }

    public Configuration configure(Document document) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("configuring from XML document");
        }
        ConfigurationParser.doConfigure(this, document);
        return this;
    }

    protected static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = Configuration.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = Configuration.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new EPException(resource + " not found");
        }
        return stream;
    }

    protected void reset() {
        this.eventClasses = new HashMap<String, String>();
        this.mapAliases = new HashMap<String, Properties>();
        this.eventTypesXMLDOM = new HashMap<String, ConfigurationEventTypeXMLDOM>();
        this.eventTypesLegacy = new HashMap<String, ConfigurationEventTypeLegacy>();
        this.databaseReferences = new HashMap<String, ConfigurationDBRef>();
        this.imports = new ArrayList<String>();
        this.addDefaultImports();
        this.isUsingDefaultImports = true;
        this.plugInViews = new ArrayList<ConfigurationPlugInView>();
        this.adapterLoaders = new ArrayList<ConfigurationAdapterLoader>();
        this.plugInAggregationFunctions = new ArrayList<ConfigurationPlugInAggregationFunction>();
        this.plugInPatternObjects = new ArrayList<ConfigurationPlugInPatternObject>();
        this.engineDefaults = new ConfigurationEngineDefaults();
        this.eventTypeAutoAliasPackages = new LinkedHashSet<String>();
        this.variables = new HashMap<String, ConfigurationVariable>();
        this.methodInvocationReferences = new HashMap<String, ConfigurationMethodRef>();
    }

    private void addDefaultImports() {
        this.imports.add("java.lang.*");
        this.imports.add("java.math.*");
        this.imports.add("java.text.*");
        this.imports.add("java.util.*");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyResolutionStyle {
        CASE_SENSITIVE,
        CASE_INSENSITIVE,
        DISTINCT_CASE_INSENSITIVE;


        public static PropertyResolutionStyle getDefault() {
            return CASE_SENSITIVE;
        }
    }
}

