/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.esper.client.ConfigurationException;
import net.esper.util.DatabaseTypeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationDBRef
implements Serializable {
    private ConnectionFactoryDesc connectionFactoryDesc;
    private ConnectionSettings connectionSettings;
    private ConnectionLifecycleEnum connectionLifecycleEnum = ConnectionLifecycleEnum.RETAIN;
    private DataCacheDesc dataCacheDesc;
    private MetadataOriginEnum metadataOrigin;
    private ColumnChangeCaseEnum columnChangeCase;
    private Map<Integer, String> javaSqlTypesMapping;

    public ConfigurationDBRef() {
        this.connectionSettings = new ConnectionSettings();
        this.metadataOrigin = MetadataOriginEnum.DEFAULT;
        this.columnChangeCase = ColumnChangeCaseEnum.NONE;
        this.javaSqlTypesMapping = new HashMap<Integer, String>();
    }

    public void setDataSourceConnection(String contextLookupName, Properties environmentProps) {
        this.connectionFactoryDesc = new DataSourceConnection(contextLookupName, environmentProps);
    }

    public void setDriverManagerConnection(String className, String url, Properties connectionArgs) {
        this.connectionFactoryDesc = new DriverManagerConnection(className, url, connectionArgs);
    }

    public void setDriverManagerConnection(String className, String url, String username, String password) {
        this.connectionFactoryDesc = new DriverManagerConnection(className, url, username, password);
    }

    public void setDriverManagerConnection(String className, String url, String username, String password, Properties connectionArgs) {
        this.connectionFactoryDesc = new DriverManagerConnection(className, url, username, password, connectionArgs);
    }

    public void setConnectionAutoCommit(boolean value) {
        this.connectionSettings.setAutoCommit(value);
    }

    public void setConnectionTransactionIsolation(int value) {
        this.connectionSettings.setTransactionIsolation(value);
    }

    public void setConnectionReadOnly(boolean isReadOnly) {
        this.connectionSettings.setReadOnly(isReadOnly);
    }

    public void setConnectionCatalog(String catalog) {
        this.connectionSettings.setCatalog(catalog);
    }

    public ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public ConnectionLifecycleEnum getConnectionLifecycleEnum() {
        return this.connectionLifecycleEnum;
    }

    public void setConnectionLifecycleEnum(ConnectionLifecycleEnum connectionLifecycleEnum) {
        this.connectionLifecycleEnum = connectionLifecycleEnum;
    }

    public ConnectionFactoryDesc getConnectionFactoryDesc() {
        return this.connectionFactoryDesc;
    }

    public void setLRUCache(int size) {
        this.dataCacheDesc = new LRUCacheDesc(size);
    }

    public void setExpiryTimeCache(double maxAgeSeconds, double purgeIntervalSeconds) {
        this.dataCacheDesc = new ExpiryTimeCacheDesc(maxAgeSeconds, purgeIntervalSeconds, CacheReferenceType.getDefault());
    }

    public void setExpiryTimeCache(double maxAgeSeconds, double purgeIntervalSeconds, CacheReferenceType cacheReferenceType) {
        this.dataCacheDesc = new ExpiryTimeCacheDesc(maxAgeSeconds, purgeIntervalSeconds, cacheReferenceType);
    }

    public DataCacheDesc getDataCacheDesc() {
        return this.dataCacheDesc;
    }

    public MetadataOriginEnum getMetadataRetrievalEnum() {
        return this.metadataOrigin;
    }

    public void setMetadataOrigin(MetadataOriginEnum metadataOrigin) {
        this.metadataOrigin = metadataOrigin;
    }

    public ColumnChangeCaseEnum getColumnChangeCase() {
        return this.columnChangeCase;
    }

    public void setColumnChangeCase(ColumnChangeCaseEnum columnChangeCaseEnum) {
        this.columnChangeCase = columnChangeCaseEnum;
    }

    public void addJavaSqlTypesBinding(int sqlType, String javaTypeName) {
        DatabaseTypeEnum typeEnum = DatabaseTypeEnum.getEnum(javaTypeName);
        if (typeEnum == null) {
            String supported = Arrays.toString((Object[])DatabaseTypeEnum.values());
            throw new ConfigurationException("Unsupported java type '" + javaTypeName + "' when expecting any of: " + supported);
        }
        this.javaSqlTypesMapping.put(sqlType, javaTypeName);
    }

    public void addJavaSqlTypesBinding(int sqlType, Class javaTypeName) {
        this.addJavaSqlTypesBinding(sqlType, javaTypeName.getName());
    }

    public Map<Integer, String> getJavaSqlTypesMapping() {
        return this.javaSqlTypesMapping;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColumnChangeCaseEnum {
        NONE,
        LOWERCASE,
        UPPERCASE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheReferenceType {
        HARD,
        SOFT,
        WEAK;


        public static CacheReferenceType getDefault() {
            return WEAK;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetadataOriginEnum {
        DEFAULT,
        METADATA,
        SAMPLE;

    }

    public static class ExpiryTimeCacheDesc
    implements DataCacheDesc,
    Serializable {
        private CacheReferenceType cacheReferenceType;
        private double maxAgeSeconds;
        private double purgeIntervalSeconds;

        public ExpiryTimeCacheDesc(double maxAgeSeconds, double purgeIntervalSeconds, CacheReferenceType cacheReferenceType) {
            this.maxAgeSeconds = maxAgeSeconds;
            this.purgeIntervalSeconds = purgeIntervalSeconds;
            this.cacheReferenceType = cacheReferenceType;
        }

        public double getMaxAgeSeconds() {
            return this.maxAgeSeconds;
        }

        public double getPurgeIntervalSeconds() {
            return this.purgeIntervalSeconds;
        }

        public CacheReferenceType getCacheReferenceType() {
            return this.cacheReferenceType;
        }

        public String toString() {
            return "ExpiryTimeCacheDesc maxAgeSeconds=" + this.maxAgeSeconds + " purgeIntervalSeconds=" + this.purgeIntervalSeconds;
        }
    }

    public static class LRUCacheDesc
    implements DataCacheDesc,
    Serializable {
        private int size;

        public LRUCacheDesc(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public String toString() {
            return "LRUCacheDesc size=" + this.size;
        }
    }

    public static interface DataCacheDesc {
    }

    public static class DriverManagerConnection
    implements ConnectionFactoryDesc,
    Serializable {
        private String className;
        private String url;
        private String optionalUserName;
        private String optionalPassword;
        private Properties optionalProperties;

        public DriverManagerConnection(String className, String url, Properties optionalProperties) {
            this.className = className;
            this.url = url;
            this.optionalProperties = optionalProperties;
        }

        public DriverManagerConnection(String className, String url, String optionalUserName, String optionalPassword) {
            this.className = className;
            this.url = url;
            this.optionalUserName = optionalUserName;
            this.optionalPassword = optionalPassword;
        }

        public DriverManagerConnection(String className, String url, String optionalUserName, String optionalPassword, Properties optionalProperties) {
            this.className = className;
            this.url = url;
            this.optionalUserName = optionalUserName;
            this.optionalPassword = optionalPassword;
            this.optionalProperties = optionalProperties;
        }

        public String getClassName() {
            return this.className;
        }

        public String getUrl() {
            return this.url;
        }

        public String getOptionalUserName() {
            return this.optionalUserName;
        }

        public String getOptionalPassword() {
            return this.optionalPassword;
        }

        public Properties getOptionalProperties() {
            return this.optionalProperties;
        }
    }

    public static class DataSourceConnection
    implements ConnectionFactoryDesc,
    Serializable {
        private String contextLookupName;
        private Properties envProperties;

        public DataSourceConnection(String contextLookupName, Properties envProperties) {
            this.contextLookupName = contextLookupName;
            this.envProperties = envProperties;
        }

        public String getContextLookupName() {
            return this.contextLookupName;
        }

        public Properties getEnvProperties() {
            return this.envProperties;
        }
    }

    public static interface ConnectionFactoryDesc {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionLifecycleEnum {
        RETAIN,
        POOLED;

    }

    public static class ConnectionSettings
    implements Serializable {
        private Boolean autoCommit;
        private String catalog;
        private Boolean readOnly;
        private Integer transactionIsolation;

        public Boolean getAutoCommit() {
            return this.autoCommit;
        }

        public void setAutoCommit(Boolean autoCommit) {
            this.autoCommit = autoCommit;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public Boolean getReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public Integer getTransactionIsolation() {
            return this.transactionIsolation;
        }

        public void setTransactionIsolation(int transactionIsolation) {
            this.transactionIsolation = transactionIsolation;
        }
    }
}

