/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.esper.client.Configuration;
import net.esper.client.ConfigurationException;
import net.esper.client.EPServiceProvider;
import net.esper.core.EPServiceProviderImpl;

public final class EPServiceProviderManager {
    private static Map<String, EPServiceProviderImpl> runtimes = Collections.synchronizedMap(new HashMap());

    public static EPServiceProvider getDefaultProvider() {
        return EPServiceProviderManager.getProvider(null, new Configuration());
    }

    public static EPServiceProvider getDefaultProvider(Configuration configuration) throws ConfigurationException {
        return EPServiceProviderManager.getProvider(null, configuration);
    }

    public static EPServiceProvider getProvider(String uri) {
        return EPServiceProviderManager.getProvider(uri, new Configuration());
    }

    public static EPServiceProvider getProvider(String uri, Configuration configuration) throws ConfigurationException {
        if (runtimes.containsKey(uri)) {
            EPServiceProviderImpl provider = runtimes.get(uri);
            provider.setConfiguration(configuration);
            return provider;
        }
        EPServiceProviderImpl runtime = new EPServiceProviderImpl(configuration, uri);
        runtimes.put(uri, runtime);
        return runtime;
    }
}

