/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.StringWriter;
import net.esper.client.soda.ConstantExpression;
import net.esper.client.soda.Expression;
import net.esper.client.soda.ExpressionBase;
import net.esper.client.soda.PropertyValueExpression;

public class ArithmaticExpression
extends ExpressionBase {
    private String operator;

    public ArithmaticExpression(String operator) {
        this.operator = operator;
    }

    public ArithmaticExpression(Expression left, String operator, Expression right) {
        this.operator = operator;
        this.addChild(left);
        this.addChild(right);
    }

    public String getOperator() {
        return this.operator;
    }

    public ArithmaticExpression add(Object object) {
        this.getChildren().add(new ConstantExpression(object));
        return this;
    }

    public ArithmaticExpression add(Expression expression) {
        this.getChildren().add(expression);
        return this;
    }

    public ArithmaticExpression add(String propertyName) {
        this.getChildren().add(new PropertyValueExpression(propertyName));
        return this;
    }

    public void toEQL(StringWriter writer) {
        writer.write("(");
        String delimiter = "";
        for (Expression child : this.getChildren()) {
            writer.write(delimiter);
            child.toEQL(writer);
            delimiter = " " + this.operator + " ";
        }
        writer.write(")");
    }
}

