/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.StringWriter;
import net.esper.client.soda.Expression;
import net.esper.client.soda.ExpressionBase;

public class BetweenExpression
extends ExpressionBase {
    private boolean isLowEndpointIncluded;
    private boolean isHighEndpointIncluded;
    private boolean isNotBetween;

    public BetweenExpression(Expression datapoint, Expression lower, Expression higher) {
        this(datapoint, lower, higher, true, true, false);
    }

    public BetweenExpression(boolean lowEndpointIncluded, boolean highEndpointIncluded, boolean notBetween) {
        this.isLowEndpointIncluded = lowEndpointIncluded;
        this.isHighEndpointIncluded = highEndpointIncluded;
        this.isNotBetween = notBetween;
    }

    public BetweenExpression(Expression datapoint, Expression lower, Expression higher, boolean lowEndpointIncluded, boolean highEndpointIncluded, boolean notBetween) {
        this.getChildren().add(datapoint);
        this.getChildren().add(lower);
        this.getChildren().add(higher);
        this.isLowEndpointIncluded = lowEndpointIncluded;
        this.isHighEndpointIncluded = highEndpointIncluded;
        this.isNotBetween = notBetween;
    }

    public void toEQL(StringWriter writer) {
        if (this.isLowEndpointIncluded && this.isHighEndpointIncluded) {
            writer.write(40);
            this.getChildren().get(0).toEQL(writer);
            writer.write(" between ");
            this.getChildren().get(1).toEQL(writer);
            writer.write(" and ");
            this.getChildren().get(2).toEQL(writer);
            writer.write(41);
        } else {
            writer.write(40);
            this.getChildren().get(0).toEQL(writer);
            writer.write(" in ");
            if (this.isLowEndpointIncluded) {
                writer.write(91);
            } else {
                writer.write(40);
            }
            this.getChildren().get(1).toEQL(writer);
            writer.write(58);
            this.getChildren().get(2).toEQL(writer);
            if (this.isHighEndpointIncluded) {
                writer.write(93);
            } else {
                writer.write(41);
            }
            writer.write(41);
        }
    }

    public boolean isLowEndpointIncluded() {
        return this.isLowEndpointIncluded;
    }

    public void setLowEndpointIncluded(boolean lowEndpointIncluded) {
        this.isLowEndpointIncluded = lowEndpointIncluded;
    }

    public boolean isHighEndpointIncluded() {
        return this.isHighEndpointIncluded;
    }

    public void setHighEndpointIncluded(boolean highEndpointIncluded) {
        this.isHighEndpointIncluded = highEndpointIncluded;
    }

    public boolean isNotBetween() {
        return this.isNotBetween;
    }

    public void setNotBetween(boolean notBetween) {
        this.isNotBetween = notBetween;
    }
}

