/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.StringWriter;
import net.esper.client.soda.ConstantExpression;
import net.esper.client.soda.Expression;
import net.esper.client.soda.ExpressionBase;
import net.esper.client.soda.PropertyValueExpression;
import net.esper.type.BitWiseOpEnum;

public class BitwiseOpExpression
extends ExpressionBase {
    private BitWiseOpEnum binaryOp;

    public BitwiseOpExpression(BitWiseOpEnum binaryOp) {
        this.binaryOp = binaryOp;
    }

    public BitwiseOpExpression add(String property) {
        this.getChildren().add(new PropertyValueExpression(property));
        return this;
    }

    public BitwiseOpExpression add(Object object) {
        this.getChildren().add(new ConstantExpression(object));
        return this;
    }

    public BitwiseOpExpression add(Expression expression) {
        this.getChildren().add(expression);
        return this;
    }

    public void toEQL(StringWriter writer) {
        boolean isFirst = true;
        for (Expression child : this.getChildren()) {
            if (!isFirst) {
                writer.write(32);
                writer.write(this.binaryOp.getExpressionText());
                writer.write(32);
            }
            child.toEQL(writer);
            isFirst = false;
        }
    }

    public BitWiseOpEnum getBinaryOp() {
        return this.binaryOp;
    }

    public void setBinaryOp(BitWiseOpEnum binaryOp) {
        this.binaryOp = binaryOp;
    }
}

