/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.StringWriter;
import net.esper.client.soda.Expression;
import net.esper.client.soda.ExpressionBase;

public class CaseSwitchExpression
extends ExpressionBase {
    public CaseSwitchExpression() {
    }

    public CaseSwitchExpression(Expression switchValue) {
        this.addChild(switchValue);
    }

    public CaseSwitchExpression add(Expression when, Expression then) {
        int size = this.getChildren().size();
        if (size % 2 == 1) {
            this.addChild(when);
            this.addChild(then);
        } else {
            this.getChildren().add(this.getChildren().size() - 1, when);
            this.getChildren().add(this.getChildren().size() - 1, then);
        }
        return this;
    }

    public CaseSwitchExpression setElse(Expression elseExpr) {
        int size = this.getChildren().size();
        if (size % 2 != 1) {
            this.getChildren().remove(size - 1);
        }
        this.addChild(elseExpr);
        return this;
    }

    public void toEQL(StringWriter writer) {
        int index;
        writer.write("case ");
        this.getChildren().get(0).toEQL(writer);
        for (index = 1; index < this.getChildren().size() - 1; ++index) {
            writer.write(" when ");
            this.getChildren().get(index).toEQL(writer);
            if (++index == this.getChildren().size()) {
                throw new IllegalStateException("Invalid case-when expression, count of when-to-then nodes not matching");
            }
            writer.write(" then ");
            this.getChildren().get(index).toEQL(writer);
        }
        if (index < this.getChildren().size()) {
            writer.write(" else ");
            this.getChildren().get(index).toEQL(writer);
        }
        writer.write(" end");
    }
}

