/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import net.esper.client.soda.ProjectedStream;
import net.esper.client.soda.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateWindowClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String windowName;
    private List<View> views;

    public static CreateWindowClause create(String windowName, View view) {
        return new CreateWindowClause(windowName, new View[]{view});
    }

    public static CreateWindowClause create(String windowName, View ... views) {
        return new CreateWindowClause(windowName, views);
    }

    public CreateWindowClause addView(String namespace, String name) {
        this.views.add(View.create(namespace, name));
        return this;
    }

    public CreateWindowClause addView(String namespace, String name, List<Object> parameters) {
        this.views.add(View.create(namespace, name, parameters));
        return this;
    }

    public CreateWindowClause(String windowName, View[] viewArr) {
        this.windowName = windowName;
        this.views = new ArrayList<View>();
        if (viewArr != null) {
            for (View view : viewArr) {
                this.views.add(view);
            }
        }
    }

    public CreateWindowClause(String windowName, List<View> views) {
        this.windowName = windowName;
        this.views = views;
    }

    public void toEQL(StringWriter writer) {
        writer.write("create window ");
        writer.write(this.windowName);
        ProjectedStream.toEQLViews(writer, this.views);
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    public List<View> getViews() {
        return this.views;
    }

    public void setViews(List<View> views) {
        this.views = views;
    }
}

