/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import net.esper.client.soda.CreateVariableClause;
import net.esper.client.soda.CreateWindowClause;
import net.esper.client.soda.Expression;
import net.esper.client.soda.FromClause;
import net.esper.client.soda.GroupByClause;
import net.esper.client.soda.InsertIntoClause;
import net.esper.client.soda.OnClause;
import net.esper.client.soda.OnDeleteClause;
import net.esper.client.soda.OnSelectClause;
import net.esper.client.soda.OnSetClause;
import net.esper.client.soda.OrderByClause;
import net.esper.client.soda.OutputLimitClause;
import net.esper.client.soda.SelectClause;
import net.esper.eql.spec.SubstitutionParameterExpression;

public class EPStatementObjectModel
implements Serializable {
    private static final long serialVersionUID = 0L;
    private CreateVariableClause createVariable;
    private CreateWindowClause createWindow;
    private OnClause onExpr;
    private InsertIntoClause insertInto;
    private SelectClause selectClause;
    private FromClause fromClause;
    private Expression whereClause;
    private GroupByClause groupByClause;
    private Expression havingClause;
    private OutputLimitClause outputLimitClause;
    private OrderByClause orderByClause;
    private List<SubstitutionParameterExpression> substitutions = new ArrayList<SubstitutionParameterExpression>();

    public EPStatementObjectModel setInsertInto(InsertIntoClause insertInto) {
        this.insertInto = insertInto;
        return this;
    }

    public InsertIntoClause getInsertInto() {
        return this.insertInto;
    }

    public EPStatementObjectModel setSelectClause(SelectClause selectClause) {
        this.selectClause = selectClause;
        return this;
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public EPStatementObjectModel setFromClause(FromClause fromClause) {
        this.fromClause = fromClause;
        return this;
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    public EPStatementObjectModel setWhereClause(Expression whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public GroupByClause getGroupByClause() {
        return this.groupByClause;
    }

    public EPStatementObjectModel setGroupByClause(GroupByClause groupByClause) {
        this.groupByClause = groupByClause;
        return this;
    }

    public Expression getHavingClause() {
        return this.havingClause;
    }

    public EPStatementObjectModel setHavingClause(Expression havingClause) {
        this.havingClause = havingClause;
        return this;
    }

    public OrderByClause getOrderByClause() {
        return this.orderByClause;
    }

    public EPStatementObjectModel setOrderByClause(OrderByClause orderByClause) {
        this.orderByClause = orderByClause;
        return this;
    }

    public OutputLimitClause getOutputLimitClause() {
        return this.outputLimitClause;
    }

    public EPStatementObjectModel setOutputLimitClause(OutputLimitClause outputLimitClause) {
        this.outputLimitClause = outputLimitClause;
        return this;
    }

    public String toEQL() {
        StringWriter writer = new StringWriter();
        if (this.createWindow != null) {
            this.createWindow.toEQL(writer);
            writer.write(" as ");
            this.selectClause.toEQL(writer);
            this.fromClause.toEQL(writer);
            return writer.toString();
        }
        if (this.createVariable != null) {
            this.createVariable.toEQL(writer);
            return writer.toString();
        }
        if (this.onExpr != null) {
            writer.write("on ");
            this.fromClause.getStreams().get(0).toEQL(writer);
            if (this.onExpr instanceof OnDeleteClause) {
                writer.write(" delete from ");
                ((OnDeleteClause)this.onExpr).toEQL(writer);
            } else if (this.onExpr instanceof OnSelectClause) {
                writer.write(" ");
                if (this.insertInto != null) {
                    this.insertInto.toEQL(writer);
                }
                this.selectClause.toEQL(writer);
                writer.write(" from ");
                ((OnSelectClause)this.onExpr).toEQL(writer);
            } else {
                OnSetClause onSet = (OnSetClause)this.onExpr;
                onSet.toEQL(writer);
            }
        } else {
            if (this.selectClause == null) {
                throw new IllegalStateException("Select-clause has not been defined");
            }
            if (this.fromClause == null) {
                throw new IllegalStateException("From-clause has not been defined");
            }
            if (this.insertInto != null) {
                this.insertInto.toEQL(writer);
            }
            this.selectClause.toEQL(writer);
            this.fromClause.toEQL(writer);
        }
        if (this.whereClause != null) {
            writer.write(" where ");
            this.whereClause.toEQL(writer);
        }
        if (this.groupByClause != null) {
            writer.write(" group by ");
            this.groupByClause.toEQL(writer);
        }
        if (this.havingClause != null) {
            writer.write(" having ");
            this.havingClause.toEQL(writer);
        }
        if (this.outputLimitClause != null) {
            writer.write(" output ");
            this.outputLimitClause.toEQL(writer);
        }
        if (this.orderByClause != null) {
            writer.write(" order by ");
            this.orderByClause.toEQL(writer);
        }
        return writer.toString();
    }

    public CreateWindowClause getCreateWindow() {
        return this.createWindow;
    }

    public void setCreateWindow(CreateWindowClause createWindow) {
        this.createWindow = createWindow;
    }

    public OnClause getOnExpr() {
        return this.onExpr;
    }

    public void setOnExpr(OnClause onExpr) {
        this.onExpr = onExpr;
    }

    public CreateVariableClause getCreateVariable() {
        return this.createVariable;
    }

    public void setCreateVariable(CreateVariableClause createVariable) {
        this.createVariable = createVariable;
    }
}

