/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.esper.client.soda.ArithmaticExpression;
import net.esper.client.soda.ArrayExpression;
import net.esper.client.soda.AvedevProjectionExpression;
import net.esper.client.soda.AvgProjectionExpression;
import net.esper.client.soda.BetweenExpression;
import net.esper.client.soda.BitwiseOpExpression;
import net.esper.client.soda.CaseSwitchExpression;
import net.esper.client.soda.CaseWhenThenExpression;
import net.esper.client.soda.CastExpression;
import net.esper.client.soda.CoalesceExpression;
import net.esper.client.soda.ConcatExpression;
import net.esper.client.soda.Conjunction;
import net.esper.client.soda.ConstantExpression;
import net.esper.client.soda.CountProjectionExpression;
import net.esper.client.soda.CountStarProjectionExpression;
import net.esper.client.soda.CurrentTimestampExpression;
import net.esper.client.soda.Disjunction;
import net.esper.client.soda.EPStatementObjectModel;
import net.esper.client.soda.Expression;
import net.esper.client.soda.InExpression;
import net.esper.client.soda.InstanceOfExpression;
import net.esper.client.soda.LikeExpression;
import net.esper.client.soda.MaxProjectionExpression;
import net.esper.client.soda.MaxRowExpression;
import net.esper.client.soda.MedianProjectionExpression;
import net.esper.client.soda.MinProjectionExpression;
import net.esper.client.soda.MinRowExpression;
import net.esper.client.soda.NotExpression;
import net.esper.client.soda.PlugInProjectionExpression;
import net.esper.client.soda.PreviousExpression;
import net.esper.client.soda.PriorExpression;
import net.esper.client.soda.PropertyExistsExpression;
import net.esper.client.soda.PropertyValueExpression;
import net.esper.client.soda.RegExpExpression;
import net.esper.client.soda.RelationalOpExpression;
import net.esper.client.soda.StaticMethodExpression;
import net.esper.client.soda.StddevProjectionExpression;
import net.esper.client.soda.SubqueryExistsExpression;
import net.esper.client.soda.SubqueryExpression;
import net.esper.client.soda.SubqueryInExpression;
import net.esper.client.soda.SumProjectionExpression;
import net.esper.type.BitWiseOpEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expressions
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static CurrentTimestampExpression currentTimestamp() {
        return new CurrentTimestampExpression();
    }

    public static PropertyExistsExpression existsProperty(String propertyName) {
        return new PropertyExistsExpression(propertyName);
    }

    public static CastExpression cast(Expression expression, String typeName) {
        return new CastExpression(expression, typeName);
    }

    public static CastExpression cast(String propertyName, String typeName) {
        return new CastExpression(Expressions.getPropExpr(propertyName), typeName);
    }

    public static InstanceOfExpression instanceOf(Expression expression, String typeName, String ... typeNames) {
        return new InstanceOfExpression(expression, typeName, typeNames);
    }

    public static InstanceOfExpression instanceOf(String propertyName, String typeName, String ... typeNames) {
        return new InstanceOfExpression(Expressions.getPropExpr(propertyName), typeName, typeNames);
    }

    public static PlugInProjectionExpression plugInAggregation(String functionName, Expression parameter) {
        return new PlugInProjectionExpression(functionName, false, parameter);
    }

    public static RegExpExpression regexp(Expression left, Expression right) {
        return new RegExpExpression(left, right);
    }

    public static RegExpExpression regexp(Expression left, Expression right, String escape) {
        return new RegExpExpression(left, right, new ConstantExpression(escape));
    }

    public static RegExpExpression regexp(String property, String regExExpression) {
        return new RegExpExpression(Expressions.getPropExpr(property), new ConstantExpression(regExExpression));
    }

    public static RegExpExpression regexp(String property, String regExExpression, String escape) {
        return new RegExpExpression(Expressions.getPropExpr(property), new ConstantExpression(regExExpression), new ConstantExpression(escape));
    }

    public static ArrayExpression array() {
        return new ArrayExpression();
    }

    public static BitwiseOpExpression binaryAnd() {
        return new BitwiseOpExpression(BitWiseOpEnum.BAND);
    }

    public static BitwiseOpExpression binaryOr() {
        return new BitwiseOpExpression(BitWiseOpEnum.BOR);
    }

    public static BitwiseOpExpression binaryXor() {
        return new BitwiseOpExpression(BitWiseOpEnum.BXOR);
    }

    public static MinRowExpression min(String propertyOne, String propertyTwo, String ... moreProperties) {
        return new MinRowExpression(propertyOne, propertyTwo, moreProperties);
    }

    public static MinRowExpression min(Expression exprOne, Expression exprTwo, Expression ... moreExpressions) {
        return new MinRowExpression(exprOne, exprTwo, moreExpressions);
    }

    public static MaxRowExpression max(String propertyOne, String propertyTwo, String ... moreProperties) {
        return new MaxRowExpression(propertyOne, propertyTwo, moreProperties);
    }

    public static MaxRowExpression max(Expression exprOne, Expression exprTwo, Expression ... moreExpressions) {
        return new MaxRowExpression(exprOne, exprTwo, moreExpressions);
    }

    public static CoalesceExpression coalesce(String propertyOne, String propertyTwo, String ... moreProperties) {
        return new CoalesceExpression(propertyOne, propertyTwo, moreProperties);
    }

    public static CoalesceExpression coalesce(Expression exprOne, Expression exprTwo, Expression ... moreExpressions) {
        return new CoalesceExpression(exprOne, exprTwo, moreExpressions);
    }

    public static ConstantExpression constant(Object value) {
        return new ConstantExpression(value);
    }

    public static CaseWhenThenExpression caseWhenThen() {
        return new CaseWhenThenExpression();
    }

    public static CaseSwitchExpression caseSwitch(Expression valueToSwitchOn) {
        return new CaseSwitchExpression(valueToSwitchOn);
    }

    public static CaseSwitchExpression caseSwitch(String propertyName) {
        return new CaseSwitchExpression(Expressions.getPropExpr(propertyName));
    }

    public static InExpression in(String property, Object ... values) {
        return new InExpression(Expressions.getPropExpr(property), false, values);
    }

    public static InExpression notIn(String property, Object ... values) {
        return new InExpression(Expressions.getPropExpr(property), true, values);
    }

    public static InExpression in(Expression value, Expression ... set) {
        return new InExpression(value, false, set);
    }

    public static InExpression notIn(Expression value, Expression ... set) {
        return new InExpression(value, true, set);
    }

    public static NotExpression not(Expression inner) {
        return new NotExpression(inner);
    }

    public static StaticMethodExpression staticMethod(String className, String method, Object ... parameters) {
        return new StaticMethodExpression(className, method, parameters);
    }

    public static StaticMethodExpression staticMethod(String className, String method, Expression ... parameters) {
        return new StaticMethodExpression(className, method, parameters);
    }

    public static PriorExpression prior(int index, String property) {
        return new PriorExpression(index, property);
    }

    public static PreviousExpression previous(Expression expression, String property) {
        return new PreviousExpression(expression, property);
    }

    public static PreviousExpression previous(int index, String property) {
        return new PreviousExpression(index, property);
    }

    public static BetweenExpression betweenProperty(String property, String lowBoundaryProperty, String highBoundaryProperty) {
        return new BetweenExpression(Expressions.getPropExpr(property), Expressions.getPropExpr(lowBoundaryProperty), Expressions.getPropExpr(highBoundaryProperty));
    }

    public static BetweenExpression between(String property, Object lowBoundary, Object highBoundary) {
        return new BetweenExpression(Expressions.getPropExpr(property), new ConstantExpression(lowBoundary), new ConstantExpression(highBoundary));
    }

    public static BetweenExpression between(Expression datapoint, Expression lowBoundary, Expression highBoundary) {
        return new BetweenExpression(datapoint, lowBoundary, highBoundary);
    }

    public static BetweenExpression range(Expression datapoint, Expression lowBoundary, Expression highBoundary, boolean isLowIncluded, boolean isHighIncluded) {
        return new BetweenExpression(datapoint, lowBoundary, highBoundary, isLowIncluded, isHighIncluded, false);
    }

    public static Disjunction or() {
        return new Disjunction();
    }

    public static Disjunction or(Expression first, Expression second, Expression ... expressions) {
        return new Disjunction(first, second, expressions);
    }

    public static Conjunction and() {
        return new Conjunction();
    }

    public static Conjunction and(Expression first, Expression second, Expression ... expressions) {
        return new Conjunction(first, second, expressions);
    }

    public static RelationalOpExpression ge(String propertyName, Object value) {
        return new RelationalOpExpression(Expressions.getPropExpr(propertyName), ">=", new ConstantExpression(value));
    }

    public static RelationalOpExpression ge(Expression left, Expression right) {
        return new RelationalOpExpression(left, ">=", right);
    }

    public static RelationalOpExpression geProperty(String propertyLeft, String propertyRight) {
        return new RelationalOpExpression(Expressions.getPropExpr(propertyLeft), ">=", new PropertyValueExpression(propertyRight));
    }

    public static RelationalOpExpression gt(String propertyName, Object value) {
        return new RelationalOpExpression(Expressions.getPropExpr(propertyName), ">", new ConstantExpression(value));
    }

    public static RelationalOpExpression gt(Expression left, Expression right) {
        return new RelationalOpExpression(left, ">", right);
    }

    public static RelationalOpExpression gtProperty(String propertyLeft, String propertyRight) {
        return new RelationalOpExpression(Expressions.getPropExpr(propertyLeft), ">", new PropertyValueExpression(propertyRight));
    }

    public static RelationalOpExpression le(String propertyName, Object value) {
        return new RelationalOpExpression(Expressions.getPropExpr(propertyName), "<=", new ConstantExpression(value));
    }

    public static RelationalOpExpression leProperty(String propertyLeft, String propertyRight) {
        return new RelationalOpExpression(Expressions.getPropExpr(propertyLeft), "<=", new PropertyValueExpression(propertyRight));
    }

    public static RelationalOpExpression le(Expression left, Expression right) {
        return new RelationalOpExpression(left, "<=", right);
    }

    public static RelationalOpExpression lt(String propertyName, Object value) {
        return new RelationalOpExpression(Expressions.getPropExpr(propertyName), "<", new ConstantExpression(value));
    }

    public static RelationalOpExpression ltProperty(String propertyLeft, String propertyRight) {
        return new RelationalOpExpression(Expressions.getPropExpr(propertyLeft), "<", new PropertyValueExpression(propertyRight));
    }

    public static RelationalOpExpression lt(Expression left, Expression right) {
        return new RelationalOpExpression(left, "<", right);
    }

    public static RelationalOpExpression eq(String propertyName, Object value) {
        return new RelationalOpExpression(Expressions.getPropExpr(propertyName), "=", new ConstantExpression(value));
    }

    public static RelationalOpExpression eqProperty(String propertyLeft, String propertyRight) {
        return new RelationalOpExpression(Expressions.getPropExpr(propertyLeft), "=", new PropertyValueExpression(propertyRight));
    }

    public static RelationalOpExpression eq(Expression left, Expression right) {
        return new RelationalOpExpression(left, "=", right);
    }

    public static RelationalOpExpression isNotNull(String property) {
        return new RelationalOpExpression(Expressions.getPropExpr(property), "!=", null);
    }

    public static RelationalOpExpression isNotNull(Expression expression) {
        return new RelationalOpExpression(expression, "!=", null);
    }

    public static PropertyValueExpression property(String propertyName) {
        return Expressions.getPropExpr(propertyName);
    }

    public static LikeExpression like(String propertyName, String value) {
        return new LikeExpression(Expressions.getPropExpr(propertyName), new ConstantExpression(value));
    }

    public static LikeExpression like(Expression left, Expression right) {
        return new LikeExpression(left, right);
    }

    public static LikeExpression like(String propertyName, Object value, String escape) {
        return new LikeExpression(Expressions.getPropExpr(propertyName), new ConstantExpression(value), new ConstantExpression(escape));
    }

    public static LikeExpression like(Expression left, Expression right, Expression escape) {
        return new LikeExpression(left, right, escape);
    }

    public static AvgProjectionExpression avg(String propertyName) {
        return new AvgProjectionExpression(Expressions.getPropExpr(propertyName), false);
    }

    public static AvgProjectionExpression avg(Expression expression) {
        return new AvgProjectionExpression(expression, false);
    }

    public static AvgProjectionExpression avgDistinct(String propertyName) {
        return new AvgProjectionExpression(Expressions.getPropExpr(propertyName), true);
    }

    public static AvgProjectionExpression avgDistinct(Expression expression) {
        return new AvgProjectionExpression(expression, true);
    }

    public static MedianProjectionExpression median(String propertyName) {
        return new MedianProjectionExpression(Expressions.getPropExpr(propertyName), false);
    }

    public static MedianProjectionExpression median(Expression expression) {
        return new MedianProjectionExpression(expression, false);
    }

    public static MedianProjectionExpression medianDistinct(String propertyName) {
        return new MedianProjectionExpression(Expressions.getPropExpr(propertyName), true);
    }

    public static MedianProjectionExpression medianDistinct(Expression expression) {
        return new MedianProjectionExpression(expression, true);
    }

    public static StddevProjectionExpression stddev(String propertyName) {
        return new StddevProjectionExpression(Expressions.getPropExpr(propertyName), false);
    }

    public static StddevProjectionExpression stddev(Expression expression) {
        return new StddevProjectionExpression(expression, false);
    }

    public static StddevProjectionExpression stddevDistinct(String propertyName) {
        return new StddevProjectionExpression(Expressions.getPropExpr(propertyName), true);
    }

    public static StddevProjectionExpression stddevDistinct(Expression expression) {
        return new StddevProjectionExpression(expression, true);
    }

    public static AvedevProjectionExpression avedev(String propertyName) {
        return new AvedevProjectionExpression(Expressions.getPropExpr(propertyName), false);
    }

    public static AvedevProjectionExpression avedev(Expression expression) {
        return new AvedevProjectionExpression(expression, false);
    }

    public static AvedevProjectionExpression avedevDistinct(String propertyName) {
        return new AvedevProjectionExpression(Expressions.getPropExpr(propertyName), false);
    }

    public static AvedevProjectionExpression avedevDistinct(Expression expression) {
        return new AvedevProjectionExpression(expression, false);
    }

    public static SumProjectionExpression sum(String propertyName) {
        return new SumProjectionExpression(Expressions.getPropExpr(propertyName), false);
    }

    public static SumProjectionExpression sum(Expression expression) {
        return new SumProjectionExpression(expression, false);
    }

    public static SumProjectionExpression sumDistinct(String propertyName) {
        return new SumProjectionExpression(Expressions.getPropExpr(propertyName), true);
    }

    public static SumProjectionExpression sumDistinct(Expression expression) {
        return new SumProjectionExpression(expression, true);
    }

    public static CountStarProjectionExpression countStar() {
        return new CountStarProjectionExpression();
    }

    public static CountProjectionExpression count(String propertyName) {
        return new CountProjectionExpression(Expressions.getPropExpr(propertyName), false);
    }

    public static CountProjectionExpression count(Expression expression) {
        return new CountProjectionExpression(expression, false);
    }

    public static CountProjectionExpression countDistinct(String propertyName) {
        return new CountProjectionExpression(Expressions.getPropExpr(propertyName), true);
    }

    public static CountProjectionExpression countDistinct(Expression expression) {
        return new CountProjectionExpression(expression, true);
    }

    public static MinProjectionExpression min(String propertyName) {
        return new MinProjectionExpression(Expressions.getPropExpr(propertyName), false);
    }

    public static MinProjectionExpression min(Expression expression) {
        return new MinProjectionExpression(expression, false);
    }

    public static MinProjectionExpression minDistinct(String propertyName) {
        return new MinProjectionExpression(Expressions.getPropExpr(propertyName), true);
    }

    public static MinProjectionExpression minDistinct(Expression expression) {
        return new MinProjectionExpression(expression, true);
    }

    public static MaxProjectionExpression max(String propertyName) {
        return new MaxProjectionExpression(Expressions.getPropExpr(propertyName), false);
    }

    public static MaxProjectionExpression max(Expression expression) {
        return new MaxProjectionExpression(expression, false);
    }

    public static MaxProjectionExpression maxDistinct(String propertyName) {
        return new MaxProjectionExpression(Expressions.getPropExpr(propertyName), true);
    }

    public static MaxProjectionExpression maxDistinct(Expression expression) {
        return new MaxProjectionExpression(expression, true);
    }

    public static ArithmaticExpression modulo(Expression left, Expression right) {
        return new ArithmaticExpression(left, "%", right);
    }

    public static ArithmaticExpression modulo(String propertyLeft, String propertyRight) {
        return new ArithmaticExpression(new PropertyValueExpression(propertyLeft), "%", new PropertyValueExpression(propertyRight));
    }

    public static ArithmaticExpression minus(Expression left, Expression right) {
        return new ArithmaticExpression(left, "-", right);
    }

    public static ArithmaticExpression minus(String propertyLeft, String propertyRight) {
        return new ArithmaticExpression(new PropertyValueExpression(propertyLeft), "-", new PropertyValueExpression(propertyRight));
    }

    public static ArithmaticExpression plus(Expression left, Expression right) {
        return new ArithmaticExpression(left, "+", right);
    }

    public static ArithmaticExpression plus(String propertyLeft, String propertyRight) {
        return new ArithmaticExpression(new PropertyValueExpression(propertyLeft), "+", new PropertyValueExpression(propertyRight));
    }

    public static ArithmaticExpression multiply(Expression left, Expression right) {
        return new ArithmaticExpression(left, "*", right);
    }

    public static ArithmaticExpression multiply(String propertyLeft, String propertyRight) {
        return new ArithmaticExpression(new PropertyValueExpression(propertyLeft), "*", new PropertyValueExpression(propertyRight));
    }

    public static ArithmaticExpression divide(Expression left, Expression right) {
        return new ArithmaticExpression(left, "/", right);
    }

    public static ArithmaticExpression divide(String propertyLeft, String propertyRight) {
        return new ArithmaticExpression(new PropertyValueExpression(propertyLeft), "/", new PropertyValueExpression(propertyRight));
    }

    public static ConcatExpression concat(String property, String ... properties) {
        ConcatExpression concat = new ConcatExpression();
        concat.getChildren().add(new PropertyValueExpression(property));
        concat.getChildren().addAll(Expressions.toPropertyExpressions(properties));
        return concat;
    }

    public static SubqueryExpression subquery(EPStatementObjectModel model) {
        return new SubqueryExpression(model);
    }

    public static SubqueryInExpression subqueryIn(String property, EPStatementObjectModel model) {
        return new SubqueryInExpression(Expressions.getPropExpr(property), model, false);
    }

    public static SubqueryInExpression subqueryNotIn(String property, EPStatementObjectModel model) {
        return new SubqueryInExpression(Expressions.getPropExpr(property), model, true);
    }

    public static SubqueryExistsExpression subqueryExists(EPStatementObjectModel model) {
        return new SubqueryExistsExpression(model);
    }

    public static SubqueryInExpression subqueryIn(Expression expression, EPStatementObjectModel model) {
        return new SubqueryInExpression(expression, model, false);
    }

    public static SubqueryInExpression subqueryNotIn(Expression expression, EPStatementObjectModel model) {
        return new SubqueryInExpression(expression, model, true);
    }

    protected static List<PropertyValueExpression> toPropertyExpressions(String ... properties) {
        ArrayList<PropertyValueExpression> expr = new ArrayList<PropertyValueExpression>();
        for (String property : properties) {
            expr.add(Expressions.getPropExpr(property));
        }
        return expr;
    }

    protected static PropertyValueExpression getPropExpr(String propertyName) {
        return new PropertyValueExpression(propertyName);
    }
}

