/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import net.esper.client.soda.OuterJoinQualifier;
import net.esper.client.soda.PropertyValueExpression;
import net.esper.client.soda.Stream;
import net.esper.collection.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private List<Stream> streams = new ArrayList<Stream>();
    private List<OuterJoinQualifier> outerJoinQualifiers = new ArrayList<OuterJoinQualifier>();

    public static FromClause create() {
        return new FromClause(new Stream[0]);
    }

    public static FromClause create(Stream stream, OuterJoinQualifier outerJoinQualifier, Stream streamSecond) {
        return new FromClause(stream, outerJoinQualifier, streamSecond);
    }

    public static FromClause create(Stream ... streams) {
        return new FromClause(streams);
    }

    public FromClause(Stream streamOne, OuterJoinQualifier outerJoinQualifier, Stream streamTwo) {
        this(streamOne);
        this.add(streamTwo);
        this.outerJoinQualifiers.add(outerJoinQualifier);
    }

    public FromClause(Stream ... streamsList) {
        for (int i = 0; i < streamsList.length; ++i) {
            this.streams.add(streamsList[i]);
        }
    }

    public FromClause add(Stream stream) {
        this.streams.add(stream);
        return this;
    }

    public FromClause add(OuterJoinQualifier outerJoinQualifier) {
        this.outerJoinQualifiers.add(outerJoinQualifier);
        return this;
    }

    public List<Stream> getStreams() {
        return this.streams;
    }

    public void toEQL(StringWriter writer) {
        String delimiter = "";
        writer.write("from ");
        if (this.outerJoinQualifiers.size() == 0) {
            for (Stream stream : this.streams) {
                writer.write(delimiter);
                stream.toEQL(writer);
                delimiter = ", ";
            }
        } else {
            if (this.outerJoinQualifiers.size() != this.streams.size() - 1) {
                throw new IllegalArgumentException("Number of outer join outerJoinQualifiers must be one less then the number of streams");
            }
            for (int i = 0; i < this.streams.size(); ++i) {
                Stream stream = this.streams.get(i);
                stream.toEQL(writer);
                if (i > 0) {
                    OuterJoinQualifier qualCond = this.outerJoinQualifiers.get(i - 1);
                    writer.write(" on ");
                    qualCond.getLeft().toEQL(writer);
                    writer.write(" = ");
                    qualCond.getRight().toEQL(writer);
                    if (qualCond.getAdditionalProperties().size() > 0) {
                        for (Pair<PropertyValueExpression, PropertyValueExpression> pair : qualCond.getAdditionalProperties()) {
                            writer.write(" and ");
                            pair.getFirst().toEQL(writer);
                            writer.write(" = ");
                            pair.getSecond().toEQL(writer);
                        }
                    }
                }
                if (i >= this.streams.size() - 1) continue;
                OuterJoinQualifier qualType = this.outerJoinQualifiers.get(i);
                writer.write(" ");
                writer.write(qualType.getType().getText());
                writer.write(" outer join ");
            }
        }
    }

    public List<OuterJoinQualifier> getOuterJoinQualifiers() {
        return this.outerJoinQualifiers;
    }
}

