/*
 * Decompiled with CFR 0.152.
 */
package net.esper.client.soda;

import java.io.StringWriter;
import net.esper.client.soda.ConstantExpression;
import net.esper.client.soda.Expression;
import net.esper.client.soda.ExpressionBase;
import net.esper.client.soda.PropertyValueExpression;

public class InExpression
extends ExpressionBase {
    boolean isNotIn;

    public InExpression(boolean isNotIn) {
        this.isNotIn = isNotIn;
    }

    public InExpression(Expression value, boolean isNotIn, Object ... parameters) {
        this.isNotIn = isNotIn;
        this.getChildren().add(value);
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof Expression) {
                this.getChildren().add((Expression)parameters[i]);
                continue;
            }
            this.getChildren().add(new ConstantExpression(parameters[i]));
        }
    }

    public boolean isNotIn() {
        return this.isNotIn;
    }

    public void setNotIn(boolean notIn) {
        this.isNotIn = notIn;
    }

    public InExpression add(Object object) {
        this.getChildren().add(new ConstantExpression(object));
        return this;
    }

    public InExpression add(Expression expression) {
        this.getChildren().add(expression);
        return this;
    }

    public InExpression add(String propertyName) {
        this.getChildren().add(new PropertyValueExpression(propertyName));
        return this;
    }

    public void toEQL(StringWriter writer) {
        this.getChildren().get(0).toEQL(writer);
        if (this.isNotIn) {
            writer.write(" not in (");
        } else {
            writer.write(" in (");
        }
        String delimiter = "";
        for (int i = 1; i < this.getChildren().size(); ++i) {
            writer.write(delimiter);
            this.getChildren().get(i).toEQL(writer);
            delimiter = ", ";
        }
        writer.write(41);
    }
}

